package it.doqui.acta.actasrv.client;

import it.csi.wso2.apiman.oauth2.helper.GenericWrapperFactoryBean;
import it.csi.wso2.apiman.oauth2.helper.OauthHelper;
import it.csi.wso2.apiman.oauth2.helper.TokenRetryManager;
import it.csi.wso2.apiman.oauth2.helper.WsProvider;
import it.csi.wso2.apiman.oauth2.helper.extra.cxf.CxfImpl;
import it.doqui.acta.acaris.backofficeservice.BackOfficeServicePort;
import it.doqui.acta.acaris.documentservice.DocumentServicePort;
import it.doqui.acta.acaris.managementservice.ManagementServicePort;
import it.doqui.acta.acaris.multifilingservice.MultifilingServicePort;
import it.doqui.acta.acaris.navigationservice.NavigationServicePort;
import it.doqui.acta.acaris.objectservice.ObjectServicePort;
import it.doqui.acta.acaris.officialbookservice.OfficialBookServicePort;
import it.doqui.acta.acaris.relationshipsservice.RelationshipsServicePort;
import it.doqui.acta.acaris.repositoryservice.RepositoryServicePort;
import it.doqui.acta.acaris.smsservice.SMSServicePort;
import it.doqui.acta.acaris.subjectregistryservice.SubjectRegistryServicePort;

public class AcarisServiceAuthenticationClient extends AcarisServiceClient {

    static final String className = "AcarisServiceAuthenticationClient";

    private static <T> T getPortTokenAPI(T port, String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret,
        Class<T> wrappedInterface) throws Exception {
        try {
            OauthHelper oauth = new OauthHelper(apiServiceUrl, consumerKey, consumerSecret);
            TokenRetryManager trm = new TokenRetryManager();
            trm.setOauthHelper(oauth);

            WsProvider wsp = new CxfImpl();
            trm.setWsProvider(wsp);

            GenericWrapperFactoryBean gwfb = new GenericWrapperFactoryBean();
            gwfb.setEndPoint(endpointServiceUrl);
            gwfb.setWrappedInterface(wrappedInterface);
            gwfb.setPort(port);
            gwfb.setTokenRetryManager(trm);

            Object o = gwfb.create();
            return wrappedInterface.cast(o);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static RepositoryServicePort getRepositoryServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret)
        throws it.doqui.acta.acaris.repositoryservice.AcarisException {
        try {
            RepositoryServicePort port = getRepositoryServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, RepositoryServicePort.class);
        } catch (it.doqui.acta.acaris.repositoryservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.repositoryservice.AcarisException(e.getMessage());
        }
    }

    public static BackOfficeServicePort getBackofficeServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret)
        throws it.doqui.acta.acaris.backofficeservice.AcarisException {
        try {
            BackOfficeServicePort port = getBackofficeServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, BackOfficeServicePort.class);
        } catch (it.doqui.acta.acaris.backofficeservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.backofficeservice.AcarisException(e.getMessage());
        }
    }

    public static ManagementServicePort getManagementServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret)
        throws it.doqui.acta.acaris.managementservice.AcarisException {
        try {
            ManagementServicePort port = getManagementServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, ManagementServicePort.class);
        } catch (it.doqui.acta.acaris.managementservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.managementservice.AcarisException(e.getMessage());
        }
    }

    public static MultifilingServicePort getMultifillingServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey,
        String consumerSecret) throws it.doqui.acta.acaris.multifilingservice.AcarisException {
        try {
            MultifilingServicePort port = getMultifillingServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, MultifilingServicePort.class);
        } catch (it.doqui.acta.acaris.multifilingservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.multifilingservice.AcarisException(e.getMessage());
        }
    }

    public static NavigationServicePort getNavigationServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret)
        throws it.doqui.acta.acaris.navigationservice.AcarisException {
        try {
            NavigationServicePort port = getNavigationServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, NavigationServicePort.class);
        } catch (it.doqui.acta.acaris.navigationservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.navigationservice.AcarisException(e.getMessage());
        }
    }

    public static ObjectServicePort getObjectServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret,
        boolean mtom) throws it.doqui.acta.acaris.objectservice.AcarisException {
        try {
            ObjectServicePort port = getObjectServiceAPI(endpointServiceUrl, mtom);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, ObjectServicePort.class);
        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.objectservice.AcarisException(e.getMessage());
        }
    }

    public static DocumentServicePort getDocumentServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret,
        boolean mtom) throws it.doqui.acta.acaris.documentservice.AcarisException {
        try {
            DocumentServicePort port = getDocumentServiceAPI(endpointServiceUrl, mtom);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, DocumentServicePort.class);
        } catch (it.doqui.acta.acaris.documentservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.documentservice.AcarisException(e.getMessage());
        }
    }

    public static SMSServicePort getSmsServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey, String consumerSecret)
        throws it.doqui.acta.acaris.smsservice.AcarisException {
        try {
            SMSServicePort port = getSmsServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, SMSServicePort.class);
        } catch (it.doqui.acta.acaris.smsservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.smsservice.AcarisException(e.getMessage());
        }
    }

    public static RelationshipsServicePort getRelationshipsServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey,
        String consumerSecret, boolean mtom) throws it.doqui.acta.acaris.relationshipsservice.AcarisException {
        try {
            RelationshipsServicePort port = getRelationshipsServiceAPI(endpointServiceUrl, false);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, RelationshipsServicePort.class);
        } catch (it.doqui.acta.acaris.relationshipsservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.relationshipsservice.AcarisException(e.getMessage());
        }
    }

    public static OfficialBookServicePort getOfficialBookServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey,
        String consumerSecret) throws it.doqui.acta.acaris.officialbookservice.AcarisException {
        try {
            OfficialBookServicePort port = getOfficialBookServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, OfficialBookServicePort.class);
        } catch (it.doqui.acta.acaris.officialbookservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.officialbookservice.AcarisException(e.getMessage());
        }
    }

    public static SubjectRegistryServicePort getSubjectRegistryServiceTokenAPI(String apiServiceUrl, String endpointServiceUrl, String consumerKey,
        String consumerSecret) throws it.doqui.acta.acaris.subjectregistryservice.AcarisException {
        try {
            SubjectRegistryServicePort port = getSubjectRegistryServiceAPI(endpointServiceUrl);
            return getPortTokenAPI(port, apiServiceUrl, endpointServiceUrl, consumerKey, consumerSecret, SubjectRegistryServicePort.class);
        } catch (it.doqui.acta.acaris.subjectregistryservice.AcarisException acEx) {
            throw acEx;
        } catch (Exception e) {
            e.printStackTrace();
            throw new it.doqui.acta.acaris.subjectregistryservice.AcarisException(e.getMessage());
        }
    }

}
