package it.doqui.acta.actasrv.client;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;

import it.doqui.acta.acaris.backofficeservice.BackOfficeService;
import it.doqui.acta.acaris.backofficeservice.BackOfficeServicePort;
import it.doqui.acta.acaris.documentservice.DocumentService;
import it.doqui.acta.acaris.documentservice.DocumentServicePort;
import it.doqui.acta.acaris.managementservice.ManagementService;
import it.doqui.acta.acaris.managementservice.ManagementServicePort;
import it.doqui.acta.acaris.multifilingservice.MultifilingService;
import it.doqui.acta.acaris.multifilingservice.MultifilingServicePort;
import it.doqui.acta.acaris.navigationservice.NavigationService;
import it.doqui.acta.acaris.navigationservice.NavigationServicePort;
import it.doqui.acta.acaris.objectservice.ObjectService;
import it.doqui.acta.acaris.objectservice.ObjectServicePort;
import it.doqui.acta.acaris.officialbookservice.OfficialBookService;
import it.doqui.acta.acaris.officialbookservice.OfficialBookServicePort;
import it.doqui.acta.acaris.relationshipsservice.RelationshipsService;
import it.doqui.acta.acaris.relationshipsservice.RelationshipsServicePort;
import it.doqui.acta.acaris.repositoryservice.AcarisException;
import it.doqui.acta.acaris.repositoryservice.RepositoryService;
import it.doqui.acta.acaris.repositoryservice.RepositoryServicePort;
import it.doqui.acta.acaris.smsservice.SMSService;
import it.doqui.acta.acaris.smsservice.SMSServicePort;
import it.doqui.acta.acaris.subjectregistryservice.SubjectRegistryService;
import it.doqui.acta.acaris.subjectregistryservice.SubjectRegistryServicePort;

public class AcarisServiceClient {

    static final String className = "AcarisServiceClient";

    private static final String URI_SEPARATOR = "/";
    private static final String SERVICE_NAME_REPOSITORY = "repositoryWS";
    private static final String SERVICE_NAME_BACKOFFICE = "backofficeWS";
    private static final String SERVICE_NAME_MANAGEMENT = "managementWS";
    private static final String SERVICE_NAME_MULTIFILLING = "multifillingWS";
    private static final String SERVICE_NAME_NAVIGATION = "navigationWS";
    private static final String SERVICE_NAME_OBJECT = "objectWS";
    private static final String SERVICE_NAME_DOCUMENT = "documentWS";
    private static final String SERVICE_NAME_SMS = "smsWS";
    private static final String SERVICE_NAME_OFFICIAL_BOOK = "officialbookWS";
    private static final String SERVICE_NAME_SUBREGISTRY = "subjectregistryWS";
    private static final String SERVICE_NAME_RELATIONSHIP = "relationshipsWS";

    public enum Protocol {
        HTTP("http://"), HTTPS("https://");

        private String scheme;

        private Protocol(String schemeString) {
            this.scheme = schemeString;
        }
    }

    private static <T> T getServiceAPI(String portPointer, QName serviceName, QName portName, Class<T> seiClass, boolean useMtom) throws Exception {

        Service service = Service.create(serviceName);
        service.addPort(portName, SOAPBinding.SOAP11HTTP_BINDING, portPointer.toString());

        WebServiceFeature[] features = useMtom ? new WebServiceFeature[] { new MTOMFeature(true) } : new WebServiceFeature[] {};
        T enpointInstance = service.getPort(portName, seiClass, features);

        return enpointInstance;
    }

    private static String createServiceEndpointURL(Protocol protocol, String server, String context, int port, Object seiName) {
        StringBuilder portPointer = new StringBuilder(protocol.scheme);
        portPointer.append(server);

        if (port > 0) {
            portPointer.append(":").append(port);
        }

        if (!context.startsWith(URI_SEPARATOR)) {
            portPointer.append(URI_SEPARATOR);
        }

        portPointer.append(context);

        if (!context.endsWith(URI_SEPARATOR)) {
            portPointer.append(URI_SEPARATOR);
        }

        portPointer.append(seiName);

        return portPointer.toString();
    }

    // Repository service
    public static RepositoryServicePort getRepositoryServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.repositoryservice.AcarisException {
        return getRepositoryServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_REPOSITORY));
    }

    public static RepositoryServicePort getRepositoryServiceAPI(String server, String context, int port) throws AcarisException {
        return getRepositoryServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_REPOSITORY));
    }

    public static RepositoryServicePort getRepositoryServiceAPI(String portPointer) throws it.doqui.acta.acaris.repositoryservice.AcarisException {
        try {
            return getServiceAPI(portPointer, RepositoryService.SERVICE, RepositoryService.RepositoryServicePort, RepositoryServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.repositoryservice.AcarisException(e.getMessage(), e);
        }
    }

    // Back office service
    public static BackOfficeServicePort getBackofficeServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.backofficeservice.AcarisException {
        return getBackofficeServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_BACKOFFICE));
    }

    public static BackOfficeServicePort getBackofficeServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.backofficeservice.AcarisException {
        return getBackofficeServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_BACKOFFICE));
    }

    public static BackOfficeServicePort getBackofficeServiceAPI(String portPointer) throws it.doqui.acta.acaris.backofficeservice.AcarisException {
        try {
            return getServiceAPI(portPointer, BackOfficeService.SERVICE, BackOfficeService.BackOfficeServicePort, BackOfficeServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.backofficeservice.AcarisException(e.getMessage(), e);
        }
    }

    // Management service
    public static ManagementServicePort getManagementServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.managementservice.AcarisException {
        return getManagementServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_MANAGEMENT));
    }

    public static ManagementServicePort getManagementServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.managementservice.AcarisException {
        return getManagementServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_MANAGEMENT));
    }

    public static ManagementServicePort getManagementServiceAPI(String portPointer) throws it.doqui.acta.acaris.managementservice.AcarisException {
        try {
            return getServiceAPI(portPointer, ManagementService.SERVICE, ManagementService.ManagementServicePort, ManagementServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.managementservice.AcarisException(e.getMessage(), e);
        }
    }

    // Multifiling service
    public static MultifilingServicePort getMultifillingServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.multifilingservice.AcarisException {
        return getMultifillingServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_MULTIFILLING));
    }

    public static MultifilingServicePort getMultifillingServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.multifilingservice.AcarisException {
        return getMultifillingServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_MULTIFILLING));
    }

    public static MultifilingServicePort getMultifillingServiceAPI(String portPointer) throws it.doqui.acta.acaris.multifilingservice.AcarisException {
        try {
            return getServiceAPI(portPointer, MultifilingService.SERVICE, MultifilingService.MultifilingServicePort, MultifilingServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.multifilingservice.AcarisException(e.getMessage(), e);
        }
    }

    // Navigation service
    public static NavigationServicePort getNavigationServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.navigationservice.AcarisException {
        return getNavigationServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_NAVIGATION));
    }

    public static NavigationServicePort getNavigationServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.navigationservice.AcarisException {
        return getNavigationServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_NAVIGATION));
    }

    public static NavigationServicePort getNavigationServiceAPI(String portPointer) throws it.doqui.acta.acaris.navigationservice.AcarisException {
        try {
            return getServiceAPI(portPointer, NavigationService.SERVICE, NavigationService.NavigationServicePort, NavigationServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.navigationservice.AcarisException(e.getMessage(), e);
        }
    }

    // Object service
    public static ObjectServicePort getObjectServiceAPI(Protocol protocol, String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.objectservice.AcarisException {
        return getObjectServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_OBJECT), mtom);
    }

    public static ObjectServicePort getObjectServiceAPI(String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.objectservice.AcarisException {
        return getObjectServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_OBJECT), mtom);
    }

    public static ObjectServicePort getObjectServiceAPI(String portPointer, boolean mtom) throws it.doqui.acta.acaris.objectservice.AcarisException {
        try {
            return getServiceAPI(portPointer, ObjectService.SERVICE, ObjectService.ObjectServicePort, ObjectServicePort.class, mtom);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.objectservice.AcarisException(e.getMessage(), e);
        }
    }

    // Document service
    public static DocumentServicePort getDocumentServiceAPI(Protocol protocol, String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.documentservice.AcarisException {
        return getDocumentServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_DOCUMENT), mtom);
    }

    public static DocumentServicePort getDocumentServiceAPI(String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.documentservice.AcarisException {
        return getDocumentServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_DOCUMENT), mtom);
    }

    public static DocumentServicePort getDocumentServiceAPI(String portPointer, boolean mtom) throws it.doqui.acta.acaris.documentservice.AcarisException {
        try {
            return getServiceAPI(portPointer, DocumentService.SERVICE, DocumentService.DocumentServicePort, DocumentServicePort.class, mtom);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.documentservice.AcarisException(e.getMessage(), e);
        }
    }

    // Sms service
    public static SMSServicePort getSmsServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.smsservice.AcarisException {
        return getSmsServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_SMS));
    }

    public static SMSServicePort getSmsServiceAPI(String server, String context, int port) throws it.doqui.acta.acaris.smsservice.AcarisException {
        return getSmsServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_SMS));
    }

    public static SMSServicePort getSmsServiceAPI(String portPointer) throws it.doqui.acta.acaris.smsservice.AcarisException {
        try {
            return getServiceAPI(portPointer, SMSService.SERVICE, SMSService.SMSServicePort, SMSServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.smsservice.AcarisException(e.getMessage(), e);
        }
    }

    // Official book service
    public static OfficialBookServicePort getOfficialBookServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.officialbookservice.AcarisException {
        return getOfficialBookServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_OFFICIAL_BOOK));
    }

    public static OfficialBookServicePort getOfficialBookServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.officialbookservice.AcarisException {
        return getOfficialBookServiceAPI(Protocol.HTTP, server, context, port);
    }

    public static OfficialBookServicePort getOfficialBookServiceAPI(String portPointer) throws it.doqui.acta.acaris.officialbookservice.AcarisException {
        try {
            return getServiceAPI(portPointer, OfficialBookService.SERVICE, OfficialBookService.OfficialBookServicePort, OfficialBookServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.officialbookservice.AcarisException(e.getMessage(), e);
        }
    }

    // Subject registry service
    public static SubjectRegistryServicePort getSubjectRegistryServiceAPI(Protocol protocol, String server, String context, int port)
        throws it.doqui.acta.acaris.subjectregistryservice.AcarisException {
        return getSubjectRegistryServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_SUBREGISTRY));
    }

    public static SubjectRegistryServicePort getSubjectRegistryServiceAPI(String server, String context, int port)
        throws it.doqui.acta.acaris.subjectregistryservice.AcarisException {
        return getSubjectRegistryServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_SUBREGISTRY));
    }

    public static SubjectRegistryServicePort getSubjectRegistryServiceAPI(String portPointer)
        throws it.doqui.acta.acaris.subjectregistryservice.AcarisException {
        try {
            return getServiceAPI(portPointer, SubjectRegistryService.SERVICE, SubjectRegistryService.SubjectRegistryServicePort,
                SubjectRegistryServicePort.class, false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.subjectregistryservice.AcarisException(e.getMessage(), e);
        }
    }

    // Relationships service
    public static RelationshipsServicePort getRelationshipsServiceAPI(Protocol protocol, String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.relationshipsservice.AcarisException {
        return getRelationshipsServiceAPI(createServiceEndpointURL(protocol, server, context, port, SERVICE_NAME_RELATIONSHIP), false);
    }

    public static RelationshipsServicePort getRelationshipsServiceAPI(String server, String context, int port, boolean mtom)
        throws it.doqui.acta.acaris.relationshipsservice.AcarisException {
        return getRelationshipsServiceAPI(createServiceEndpointURL(Protocol.HTTP, server, context, port, SERVICE_NAME_RELATIONSHIP), mtom);
    }

    public static RelationshipsServicePort getRelationshipsServiceAPI(String portPointer, boolean mtom)
        throws it.doqui.acta.acaris.relationshipsservice.AcarisException {
        try {
            return getServiceAPI(portPointer, RelationshipsService.SERVICE, RelationshipsService.RelationshipsServicePort, RelationshipsServicePort.class,
                false);
        } catch (Exception e) {
            throw new it.doqui.acta.acaris.relationshipsservice.AcarisException(e.getMessage(), e);
        }
    }

}
