package it.doqui.acta.actasrv.fruitori;

import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;

public class ConfigurazioneFruitore {

    private ParametriAcaris parametri;
    private ServiziAcaris serviziAcaris;
    private String fruitore;

    public ConfigurazioneFruitore(String server, String context, int port, String repositoryName, String codiceFiscale, long idAoo, long idNodo,
        long idStruttura, String appKey, boolean mtomEnabled) {
        parametri = new ParametriAcaris(server, context, port);
        parametri.setRepositoryName(repositoryName);
        parametri.setCodiceFiscale(codiceFiscale);
        parametri.setIdAoo(idAoo);
        parametri.setIdNodo(idNodo);
        parametri.setIdStruttura(idStruttura);
        parametri.setAppKey(appKey);
        serviziAcaris = new ServiziAcaris(parametri.getServer(), parametri.getContext(), parametri.getPort(), mtomEnabled);
    }

    public ParametriAcaris getParametri() {
        return parametri;
    }

    public void setParametri(ParametriAcaris parametri) {
        this.parametri = parametri;
    }

    public ServiziAcaris getServiziAcaris() {
        return serviziAcaris;
    }

    public void setServiziAcaris(ServiziAcaris serviziAcaris) {
        this.serviziAcaris = serviziAcaris;
    }

    public String getFruitore() {
        return fruitore;
    }

    public void setFruitore(String fruitore) {
        this.fruitore = fruitore;
    }

}
