package it.doqui.acta.actasrv.fruitori.esempi;

import it.doqui.acta.actasrv.dto.acaris.type.archive.AcarisRepositoryEntryType;
import it.doqui.acta.actasrv.dto.acaris.type.backoffice.ClientApplicationInfo;
import it.doqui.acta.actasrv.dto.acaris.type.backoffice.PrincipalExtResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.CodiceFiscaleType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdAOOType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdNodoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdStrutturaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;

public class ConnessioneAcaris {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;
    private final long ID_AOO = 231;
    private final long ID_NODO = 724;
    private final long ID_STRUTTURA = 709;
    private final String COD_FISCALE = "";
    private final String APP_KEY = "";
    private final String REP_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";
    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD
    
    private ConfigurazioneFruitore configurazione = null;
    
    public ConnessioneAcaris() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REP_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }

    public static void main(String args[]) throws Exception {
        ConnessioneAcaris testConnect = new ConnessioneAcaris();

        // Cerca Repository
        // operazione:getRepositories
        AcarisRepositoryEntryType[] reps = null;
        try {
            reps = testConnect.configurazione.getServiziAcaris().getRepositoryServicePort().getRepositories();
        } catch (it.doqui.acta.acaris.repositoryservice.AcarisException acEx) {
            System.out.println("acEx.getMessage(): " + acEx.getMessage());
            System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            System.out.println("acEx.getFaultInfo().getTechnicalInfo: " + acEx.getFaultInfo().getTechnicalInfo());
            return;
        } catch (Exception ex) {
            ex.printStackTrace();
            return;
        }

        ObjectIdType repId = null;
        System.out.println("REP:");
        for (AcarisRepositoryEntryType acarisRepositoryEntryType : reps) {
            System.out.println(acarisRepositoryEntryType.getRepositoryName() + " " + acarisRepositoryEntryType.getRepositoryId().getValue());
            if (acarisRepositoryEntryType.getRepositoryName() != null
                && acarisRepositoryEntryType.getRepositoryName().startsWith(testConnect.configurazione.getParametri().getRepositoryName(), 0)) {
                repId = acarisRepositoryEntryType.getRepositoryId();
            }
        }

        if (repId == null) {
            throw new IllegalArgumentException("Errore: repository " + testConnect.configurazione.getParametri().getRepositoryName() + " non trovato");
        }

        // Genera Principal
        CodiceFiscaleType cf = new CodiceFiscaleType();
        cf.setValue(testConnect.configurazione.getParametri().getCodiceFiscale());

        ClientApplicationInfo cai = new ClientApplicationInfo();
        cai.setAppKey(testConnect.configurazione.getParametri().getAppKey());

        IdAOOType aoo = new IdAOOType();
        aoo.setValue(testConnect.configurazione.getParametri().getIdAoo());

        IdStrutturaType struttura = new IdStrutturaType();
        struttura.setValue(testConnect.configurazione.getParametri().getIdStruttura());

        IdNodoType nodo = new IdNodoType();
        nodo.setValue(testConnect.configurazione.getParametri().getIdNodo());

        try {
            PrincipalExtResponseType[] principal = testConnect.configurazione.getServiziAcaris().getBackOfficeServicePort().getPrincipalExt(repId, cf, aoo, struttura, nodo,
                cai);
            PrincipalIdType principalId = principal[0].getPrincipalId();
            System.out.println("Principal=" + principalId.getValue());
        } catch (it.doqui.acta.acaris.backofficeservice.AcarisException acEx) {
            System.out.println("acEx.getMessage(): " + acEx.getMessage());
            System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            System.out.println("acEx.getFaultInfo().getTechnicalInfo: " + acEx.getFaultInfo().getTechnicalInfo());
            return;
        } catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}