package it.doqui.acta.actasrv.fruitori.esempi.documentService.creaDocumento;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.activation.DataHandler;

import it.doqui.acta.actasrv.dto.acaris.type.archive.ClassificazionePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ContenutoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoSemplicePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumDocPrimarioType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumTipoDocumentoType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.IdFormaDocumentariaType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.IdStatoDiEfficaciaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisContentStreamType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumMimeTypeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumStreamId;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryNameType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.document.ContenutoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoArchivisticoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumStepErrorAction;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoDocumentoArchivistico;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoOperazione;
import it.doqui.acta.actasrv.dto.acaris.type.document.IdentificatoreDocumento;
import it.doqui.acta.actasrv.dto.acaris.type.management.VitalRecordCodeType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;

public class CreaDocumentoSempliceElettronico {

    private static final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private static final String PART228_CONTEXT = "actasrv";
    private static final int PART228_PORT = 80;
            
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private static final String COD_FISCALE = "";
    private static final long ID_AOO = 0L;
    private static final long ID_NODO = 0L;
    private static final long ID_STRUTTURA = 0L;
    private static final String APP_KEY = "";
    private static final String CODICE_ENTE = "RP201209";
    private static final String DESCRIZIONE_ENTE = "Regione Piemonte - Agg. 09/2012";
    private static final String REPOSITORY_NAME = CODICE_ENTE + " " + DESCRIZIONE_ENTE;
    
    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD
    
    private ConfigurazioneFruitore configurazione = null;
    
    private static final String FILE_FOLDER_PATH = "files" + File.separatorChar;
    
    // repositoryId ottenuto dall'invocazione del getRepositories
    private ObjectIdType repositoryId;
    // principalId ottenuto tramite invocazione del servizio getPrincipalExt
    private PrincipalIdType principalId;
    
    public CreaDocumentoSempliceElettronico() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }

    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }
    
    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }

    
    /**********************************************************************************************************
     * visualizzazione risultati
     *********************************************************************************************************/

    private void stampa(ObjectResponseType[] recordset) {
        if (recordset == null) {
            System.out.println("ATTENZIONE: recordset null");
        } else {
            int max = recordset.length;
            for (int i = 0; i < max; i++) {
                System.out.println("--------------" + (i + 1) + "--------------");
                ObjectResponseType ort = null;
                if (recordset[i] != null) {
                    ort = recordset[i];
                    for (int j = 0; j < ort.getPropertiesLength(); j++) {
                        PropertyType pt = ort.getProperties(j);
                        System.out.println(pt.getQueryName().getClassName() + "." + pt.getQueryName().getPropertyName() + ": ");
                        for (int k = 0; k < pt.getValue().getContentLength(); k++) {
                            System.out.println("    " + pt.getValue().getContent(k));
                        }
                    }
                    System.out.println();
                }

            }
        }
    }

    private void stampa(IdentificatoreDocumento iDoc) {
        System.out.println("---------------------- IdentificazioneDocumento --------------------");
        String objectIdValue = iDoc.getObjectIdDocumento().getValue();
        System.out.println("objectId: " + objectIdValue);

        System.out.println("tipo documento: " + iDoc.getTipoDocumento().toString());
        System.out.println("data ultimo aggiornamento: " + iDoc.getDataUltimoAggiornamento().getValue());
//        System.out.println("numero passi falliti verifica firma:" + iDoc.getFailedStepsInfo().length);
    }

    public IdentificatoreDocumento test_creaDocumentoElettronicoNonFirmato(ObjectIdType parentFolder) {

        IdentificatoreDocumento documentId = null;
        DocumentoArchivisticoIRC datiCreazione = new DocumentoArchivisticoIRC();
        try {

            DocumentoSemplicePropertiesType properties = new DocumentoSemplicePropertiesType();

            SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");

            properties.setRegistrato(true);
            properties.setDefinitivo(true);
            properties.setModificabile(false);

            properties.setOrigineInterna(true);
            properties.setAnalogico(false);
            properties.setDaConservare(false);
            properties.setProntoPerConservazione(false);
            // properties.setDaConservareDopoIl(formatDate.parse("06/10/2010"));
            // properties.setDaConservarePrimaDel(formatDate.parse("06/10/2010"));
            properties.setDaConservarePrimaDel(null);
            properties.setDatiPersonali(true);
            properties.setDatiRiservati(false);
            properties.setDatiSensibili(false);
            properties.setParoleChiave("test-creaDocumento-fruitore");
            String[] autore = { "pippo|SCIRNP17A01L219B", "topolino|TPLMCK17A01L219B" };
            properties.setAutoreGiuridico(autore);
            properties.setAutoreFisico(autore);
            properties.setScrittore(autore);
            properties.setOriginatore(autore);
            properties.setDestinatarioGiuridico(autore);
            properties.setDestinatarioFisico(autore);
            properties.setOggetto("test crea documento - esempio");
            // properties.setOggetto(null);
            properties.setDataDocTopica("Torino");
            properties.setDataDocCronica(new Date());
            properties.setNumRepertorio("92");
            properties.setDocConAllegati(false);
            properties.setDocAutenticato(false);
            properties.setDocAutenticatoCopiaAutentica(false);
            properties.setDocAutenticatoFirmaAutenticata(false);
            properties.setContentStreamFilename("AllegatoTecnicoAcarisEstrattoServizi");

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio query, entita "StatoDiEfficaciaDecodifica"
            // IdStatoDiEfficaciaType idStatoE = new IdStatoDiEfficaciaType();
            // idStatoE.setValue(2);

            String descrizioneStatoEfficacia = "Perfetto ed efficace ma non firmato";
            IdStatoDiEfficaciaType idStatoE = queryForStatoEfficacia(descrizioneStatoEfficacia);
            if (idStatoE == null) {
                System.err.println("non trovato uno stato di efficacia con descrizione " + descrizioneStatoEfficacia);
                return null;
            }
            properties.setIdStatoDiEfficacia(idStatoE);

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio query, entita "FormaDocumentariaDecodifica"
//            String descrizioneFormaDocumentaria = "";
//            IdFormaDocumentariaType idFormaDoc = queryForFormaDocumentaria(descrizioneFormaDocumentaria, CODICE_ENTE);
//            if (idFormaDoc == null) {
//                System.err.println("non trovata una forma documentaria con descrizione " + descrizioneFormaDocumentaria);
//                return null;
//            }
//            properties.setIdFormaDocumentaria(idFormaDoc);

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio managementService.getVitalRecordCode
            String vrcDescrizione = "alto";
            VitalRecordCodeType[] vrcArray = getServiziAcaris().getManagementServicePort().getVitalRecordCode(getRepositoryId());
            for (VitalRecordCodeType vrc : vrcArray) {
                if (vrcDescrizione.equalsIgnoreCase(vrc.getDescrizione())) {
                    System.out.println("Trovato vital record code " + vrcDescrizione + " con id " + vrc.getIdVitalRecordCode().getValue());
                    properties.setIdVitalRecordCode(vrc.getIdVitalRecordCode());
                    break;
                }
            }

            // properties.setTipoDocFisico(EnumTipoDocumentoType.FIRMATO);
            properties.setTipoDocFisico(EnumTipoDocumentoType.SEMPLICE);
            // properties.setCodBarre("codiceBARRE");

            properties.setComposizione(EnumDocPrimarioType.DOCUMENTO_SINGOLO);
            properties.setMultiplo(false);

            ClassificazionePropertiesType associativeObjectProperties = new ClassificazionePropertiesType();
            // associativeObjectProperties.setNumeroInput("1234124");
            // valore indicato in sede di analisi archivistica
            associativeObjectProperties.setCopiaCartacea(false);

            properties.setRappresentazioneDigitale(true); // per doc elettronico
            associativeObjectProperties.setCollocazioneCartacea("locazione polverosa");
            // valore indicato in sede di analisi archivistica
            associativeObjectProperties.setCartaceo(true);

            // creazione contenuto fisico e relativo stream dati
            ContenutoFisicoIRC[] contenuti = new ContenutoFisicoIRC[1];
            contenuti[0] = new ContenutoFisicoIRC();
            AcarisContentStreamType contentStream = creaContentStream(FILE_FOLDER_PATH, "prova.pdf", "pdf", EnumMimeTypeType.APPLICATION_PDF);
            contenuti[0].setStream(contentStream);
            contenuti[0].setTipo(EnumStreamId.PRIMARY);
            // contenuti[0].setTipo(EnumStreamId.SIGNATURE);
            contenuti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());

            ContenutoFisicoPropertiesType contenutoFisicoPropertiesType = new ContenutoFisicoPropertiesType();
            // definire a true per sbustare il contenuto fisico
            contenutoFisicoPropertiesType.setSbustamento(false);
            contenuti[0].setPropertiesContenutoFisico(contenutoFisicoPropertiesType);

            // creazione documento fisico
            DocumentoFisicoIRC[] documenti = new DocumentoFisicoIRC[1];
            documenti[0] = new DocumentoFisicoIRC();
            DocumentoFisicoPropertiesType documentoFisicoProperty = new DocumentoFisicoPropertiesType();
            documentoFisicoProperty.setDescrizione("documento fisico");
            documentoFisicoProperty.setDataMemorizzazione(new Date());
            documenti[0].setPropertiesDocumentoFisico(documentoFisicoProperty);
            documenti[0].setContenutiFisici(contenuti);
            documenti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());

            datiCreazione.setParentFolderId(parentFolder);
            datiCreazione.setTipoDocumento(EnumTipoDocumentoArchivistico.DOCUMENTO_SEMPLICE);
            datiCreazione.setPropertiesDocumento(properties);
            datiCreazione.setPropertiesClassificazione(associativeObjectProperties);
            datiCreazione.setDocumentiFisici(documenti);

            EnumTipoOperazione tipoOperazione = EnumTipoOperazione.ELETTRONICO;

            documentId = getServiziAcaris().getDocumentServicePort().creaDocumento(getRepositoryId(), getPrincipalId(), tipoOperazione, datiCreazione);
        } catch (it.doqui.acta.acaris.documentservice.AcarisException acEx) {
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
        } catch (IOException e) {
            System.err.println("errore nella creazione del contentStream");
            e.printStackTrace();
        } catch (Exception ex) {
            System.err.println("errore nella classificazione del documento");
            ex.printStackTrace();
        }

        return documentId;
    }

    private AcarisContentStreamType creaContentStream(String filePath, final String fileName, final String estensioneFile, EnumMimeTypeType mimeType)
        throws IOException {

        AcarisContentStreamType contentStream = new AcarisContentStreamType();
        contentStream.setFilename(fileName);
        contentStream.setMimeType(mimeType);

        byte[] stream = getBytesFromFile(filePath + fileName);

        if (getServiziAcaris().isMtomEnabled()) {
            final InputStream iS = new ByteArrayInputStream(stream);
            final OutputStream oS = new ByteArrayOutputStream(stream.length);

            javax.activation.DataSource a = new javax.activation.DataSource() {

                public OutputStream getOutputStream() throws IOException {
                    return oS;
                }

                public String getName() {
                    return fileName;
                }

                public InputStream getInputStream() throws IOException {
                    return iS;
                }

                public String getContentType() {
                    return estensioneFile;
                }
            };

            // valorizzare StreamMTOM se servizio invocato via WS SOAP
            contentStream.setStreamMTOM(new DataHandler(a));
        } else {
            // valorizzare Stream se servizio invocato via PAPD
            contentStream.setStream(stream);
        }

        return contentStream;
    }

    private byte[] getBytesFromFile(String filePath) throws IOException {
        File file = new File(filePath);

        InputStream is = new FileInputStream(file);

        long length = file.length();

        if (length > Integer.MAX_VALUE) {
            System.out.println("File is too large");
        }

        byte[] bytes = new byte[(int) length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }

        if (offset < bytes.length) {
            System.out.println("File is too large" + file.getName());
        }

        is.close();
        return bytes;
    }

    private it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] getDatiTestAzioniVerificaFirma() {

        it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] azioniVerificaFirma = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[7];
        for (int i = 0; i < 7; i++) {
            azioniVerificaFirma[i] = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction();
            azioniVerificaFirma[i].setAction(EnumStepErrorAction.INSERT);
            azioniVerificaFirma[i].setStep(i + 1);
        }

        return azioniVerificaFirma;
    }

    private IdStatoDiEfficaciaType queryForStatoEfficacia(String descrizioneStatoEfficacia) throws Exception {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject("StatoDiEfficaciaDecodifica");

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.LIST);

        List<QueryNameType> richieste = new ArrayList<QueryNameType>();
        QueryNameType richiesta = new QueryNameType();
        richiesta.setClassName(target.getObject());
        richiesta.setPropertyName("dbKey");
        richieste.add(richiesta);
        filter.setPropertyList(richieste.toArray(new QueryNameType[richieste.size()]));

        List<QueryConditionType> criteria = new ArrayList<QueryConditionType>();
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("descrizione");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descrizioneStatoEfficacia);
        criteria.add(qct);

        IdStatoDiEfficaciaType idStatoEfficacia = null;

        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter,
                criteria.toArray(new QueryConditionType[criteria.size()]), null, null, new Integer(0));

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("dbKey".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        idStatoEfficacia = new IdStatoDiEfficaciaType();
                        idStatoEfficacia.setValue(Long.parseLong(current.getValue().getContent(0)));
                        System.out.println("Trovato stato di efficacia " + descrizioneStatoEfficacia + ", value " + idStatoEfficacia.getValue());
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("errore nella ricerca dello stato di efficacia");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore nella ricerca dello stato di efficacia");
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }

        return idStatoEfficacia;
    }

    private IdFormaDocumentariaType queryForFormaDocumentaria(String descrizioneFormaDocumentaria, String descEnte) throws Exception {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject("FormaDocumentariaDecodifica");

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.LIST);

        List<QueryNameType> richieste = new ArrayList<QueryNameType>();
        QueryNameType richiesta = new QueryNameType();
        richiesta.setClassName(target.getObject());
        richiesta.setPropertyName("dbKey");
        richieste.add(richiesta);
        filter.setPropertyList(richieste.toArray(new QueryNameType[richieste.size()]));

        List<QueryConditionType> criteria = new ArrayList<QueryConditionType>();
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("descrizione");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descrizioneFormaDocumentaria);
        criteria.add(qct);
        qct = new QueryConditionType();
        qct.setPropertyName("descEnte");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descEnte);
        criteria.add(qct);

        IdFormaDocumentariaType idFormaDocumentaria = null;

        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter,
                criteria.toArray(new QueryConditionType[criteria.size()]), null, null, new Integer(0));

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("dbKey".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        idFormaDocumentaria = new IdFormaDocumentariaType();
                        idFormaDocumentaria.setValue(Long.parseLong(current.getValue().getContent(0)));
                        System.out.println("Trovata forma documentaria " + descrizioneFormaDocumentaria + ", value " + idFormaDocumentaria.getValue());
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("errore nella ricerca della forma documentaria");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore nella ricerca della forma documentaria");
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }

        return idFormaDocumentaria;

    }
    
    private String test_ricercaAggregazionePerParolaChiave(String parolaChiave, EnumObjectType targetType) {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(targetType.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.NONE);

        QueryConditionType[] criteria = new QueryConditionType[1];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("paroleChiave");
        criteria[0].setOperator(EnumQueryOperator.EQUALS); //ricerca della parola chiave ESATTA
        criteria[0].setValue(parolaChiave);

        Integer maxItems = new Integer(5);

        String objectIdVolume = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria, null,
                maxItems, null);

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                        && current.getValue().getContentLength() == 1) {
                        objectIdVolume = current.getValue().getContent(0);
                        break;
                    }
                }

                if (objectIdVolume == null) {
                    throw new Exception("query errata!");
                }

            } else {
                throw new Exception("query errata!");
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.out.println("acEx.getMessage(): " + acEx.getMessage());
            System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            System.out.println("acEx.getFaultInfo().getTechnicalInfo: " + acEx.getFaultInfo().getTechnicalInfo());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return objectIdVolume;
    }

    private ObjectIdType getRepositoryId() {
        if (repositoryId == null) {
            repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
        }

        return repositoryId;
    }

    private PrincipalIdType getPrincipalId() {
        if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
        }

        return principalId;
    }

    public static void main(String[] args) {

        CreaDocumentoSempliceElettronico testCD = new CreaDocumentoSempliceElettronico();
        System.out.println("\n ********************** test creaDocumento inizio");

        // objectId che identifica il volume, cercato tramite query su paroleChiave
        String objectIdVolume = testCD.test_ricercaAggregazionePerParolaChiave("parola chiave test acaris",  EnumObjectType.FASCICOLO_REALE_LIBERO_PROPERTIES_TYPE);

        if (objectIdVolume != null) {
            ObjectIdType aggregazioneParent = new ObjectIdType();
            aggregazioneParent.setValue(objectIdVolume);
            IdentificatoreDocumento documentId = testCD.test_creaDocumentoElettronicoNonFirmato(aggregazioneParent);

            if (documentId != null) {
                testCD.stampa(documentId);
            }

        }
    }
}
