package it.doqui.acta.actasrv.fruitori.esempi.objectService.closeFolder;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import it.doqui.acta.acaris.objectservice.AcarisException;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ClassificazionePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ContenutoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoSemplicePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumDocPrimarioType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumFolderObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumTipoDocumentoType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.VolumeSerieTipologicaDocumentiPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisContentStreamType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumMimeTypeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumStreamId;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.document.ContenutoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoArchivisticoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoDocumentoArchivistico;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoOperazione;
import it.doqui.acta.actasrv.dto.acaris.type.document.IdentificatoreDocumento;
import it.doqui.acta.actasrv.dto.acaris.type.management.VitalRecordCodeType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.TestUtils;

public class ChiudiVolume {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;
    
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private final String COD_FISCALE = "";
    private final long ID_AOO = 0L;
    private final long ID_NODO = 0L;
    private final long ID_STRUTTURA = 0L;
    private final String APP_KEY = "";
    private final String REPOSITORY_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";
    
    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD
    
    private ConfigurazioneFruitore configurazione = null;
    
	private static final String PAROLA_CHIAVE_VOLUME_STD = "parola_chiave_test_close_folder";
    private static final int N_CLASSIFICAZIONI = 2;
    private ObjectIdType repositoryId;
	private PrincipalIdType principalId;
	
    public ChiudiVolume() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }

    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }
    
    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }
    
    public void chiudiAggregazione(ObjectIdType objectIdAggregazione) {
        if(objectIdAggregazione == null) {
            System.err.println("ObjectId nullo!");
            return;
        }
        
        try {
            System.out.println("invocazione di closeFolder per aggregazione " + objectIdAggregazione.getValue());
            /**
             * Servizio per effettuare la chiusura di una aggregazione.
             * Disponibile per tutti i tipi di aggregazione disponibili su ACTA per cui  prevista la chiusura (tutti tranne SOTTOFASCICOLO)
             * 
             * @param repositoryId
             * @param objectIdAggregazione
             * @param principalId
             * @return SingleResponseType oggetto contenente ogjectId dell'aggregazione chiusa e ChangeTokenType che indica il timestamp dell'avvenuta chiusura
             * @throws AcarisException nello specifico, i pi rilevanti per il business della chiusura volume
             *      SER-E032 - attore non abilitato alla chiusura del tipo di aggregazione specifico
             *      SER-E192/193/194 - operazione consentita solo all'utente responsabile della serie (o fascicolo o fascicolo padre del sottofascicolo) in cui  contenuto il volume
             *      SER_E195 - il volume contiene dei documenti in stato modificabile
             *      SER_E196 - presenza nel volume di un documento bloccato per operazione di smistamento
             */
            getServiziAcaris().getObjectServicePort().closeFolder(getRepositoryId(), objectIdAggregazione, getPrincipalId());
            System.out.println("chiusura aggregazione effettuata con successo");
        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
        }
    }
    
	public ObjectIdType creaVolumeSerieTipologicaDocumenti(ObjectIdType aggregazioneParent) {
		ObjectIdType result = null;
		
		try {
//			impostare il tipo di volume che si vuole creare tra quelli a disposizione
//			in base a quanto indicato in analisi archivistica
//			Utilizzare EnumFolderObjectType	per conoscere i tipi di volumi disponibili
			EnumFolderObjectType typeId = EnumFolderObjectType.VOLUME_SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE;

//			utilizzare la property corrispondente al typeId utilizzato
//			propertyesType disponibili:
//				VolumeFascicoliPropertiesType.class
//				VolumeSerieFascicoliPropertiesType.class
//				VolumeSottofascicoliPropertiesType.class
//				VolumeSerieTipologicaDocumentiPropertiesType.class
			VolumeSerieTipologicaDocumentiPropertiesType volumeSerieProperties = new VolumeSerieTipologicaDocumentiPropertiesType();

			//valorizzare i seguenti parametri in base all'analisi archivistica
			volumeSerieProperties.setConservazioneCorrente(1);
			volumeSerieProperties.setConservazioneGenerale(2);
			volumeSerieProperties.setCollocazioneCartaceo("Collocazione cartacea fittizia");
			volumeSerieProperties.setDescrizione("Volume creato via acaris");
			volumeSerieProperties.setParoleChiave(PAROLA_CHIAVE_VOLUME_STD);

			result = getServiziAcaris().getObjectServicePort().createFolder(getRepositoryId(), typeId, getPrincipalId(),
					volumeSerieProperties, aggregazioneParent);

		} catch (AcarisException acEx) {
			System.out.println("acEx.getMessage(): " + acEx.getMessage());
			System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
			System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
			System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
			System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
			System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
		}
		
		if(result != null) {
			System.out.println("---------------------- Aggregazione creata --------------------");
			System.out.println("objectId: " + result.getValue());
		}
		
		return result;
	}
	
	private ObjectIdType ricercaPerParolaChiave(EnumFolderObjectType folderType, String parolaChiave) {
		QueryableObjectType target = new QueryableObjectType();
		target.setObject(folderType.value());

		PropertyFilterType filter = new PropertyFilterType();
		filter.setFilterType(EnumPropertyFilter.NONE);

		QueryConditionType[] criteria = new QueryConditionType[2];
		criteria[0] = new QueryConditionType();
		criteria[0].setPropertyName("paroleChiave");
        criteria[0].setOperator(EnumQueryOperator.EQUALS); //ricerca della parola chiave ESATTA
		criteria[0].setValue(parolaChiave);

        int idStato = isSerie(folderType) ? 2 : 1;
        criteria[1] = new QueryConditionType();
        criteria[1].setPropertyName("stato");
        criteria[1].setOperator(EnumQueryOperator.EQUALS);
        criteria[1].setValue("" + idStato);

		Integer maxItems = new Integer(5);

		ObjectIdType objectIdVolume = null;
		try {
			PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target,
					filter, criteria, null, maxItems, null);

			if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null
					&& result.getObjects(0).getPropertiesLength() > 0) {
				for (PropertyType current : result.getObjects(0).getProperties()) {
					if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
							&& current.getValue().getContentLength() == 1) {
					    objectIdVolume = new ObjectIdType();
						objectIdVolume.setValue(current.getValue().getContent(0));
						break;
					}
				}

				if (objectIdVolume == null) {
					throw new Exception("query errata!");
				}

			} else {
				throw new Exception("query errata!");
			}

		} catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
			System.out.println("acEx.getMessage(): " + acEx.getMessage());
			System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
			System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
			System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
			System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
			System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		return objectIdVolume;
	}

	private boolean isSerie(EnumFolderObjectType folderType) {
        EnumFolderObjectType[] series = new EnumFolderObjectType[] { EnumFolderObjectType.SERIE_DOSSIER_PROPERTIES_TYPE,
            EnumFolderObjectType.SERIE_FASCICOLI_PROPERTIES_TYPE, EnumFolderObjectType.SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE };
        
        for(EnumFolderObjectType tipo: series) {
            if (tipo == folderType) {
                return true;
            }
        }
        return false;
    }

    private ObjectIdType getRepositoryId() {
		if (repositoryId == null) {
			repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
		}
		return repositoryId;
	}

	private PrincipalIdType getPrincipalId() {
		if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
		}
		
		return principalId;
	}
	
	public IdentificatoreDocumento creaClassificazioneDefinitivaDocumentoElenttronico(ObjectIdType parentFolder) throws Exception {

        IdentificatoreDocumento documentId = null;
        DocumentoArchivisticoIRC datiCreazione = new DocumentoArchivisticoIRC();
        try {

            DocumentoSemplicePropertiesType properties = new DocumentoSemplicePropertiesType();

            SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");

            properties.setRegistrato(true);
            properties.setDefinitivo(true);
            properties.setModificabile(false);

            properties.setOrigineInterna(true);
            properties.setAnalogico(false);
            properties.setDaConservare(false);
            properties.setProntoPerConservazione(false);
            // properties.setDaConservareDopoIl(formatDate.parse("06/10/2010"));
            // properties.setDaConservarePrimaDel(formatDate.parse("06/10/2010"));
            properties.setDaConservarePrimaDel(null);
            properties.setDatiPersonali(true);
            properties.setDatiRiservati(false);
            properties.setDatiSensibili(false);
            properties.setParoleChiave("test-creaDocumento-fruitore");
            String[] autore = { "pippo|PPPGFY80A01L219S", "topolino|TPLMCK17A01L219B" };
            properties.setAutoreGiuridico(autore);
            properties.setAutoreFisico(autore);
            properties.setScrittore(autore);
            properties.setOriginatore(autore);
            properties.setDestinatarioGiuridico(autore);
            properties.setDestinatarioFisico(autore);
            properties.setOggetto("test crea documento - esempio");
            // properties.setOggetto(null);
            properties.setDataDocTopica("Torino");
            properties.setDataDocCronica(new Date());
            properties.setNumRepertorio("92");
            properties.setDocConAllegati(false);
            properties.setDocAutenticato(false);
            properties.setDocAutenticatoCopiaAutentica(false);
            properties.setDocAutenticatoFirmaAutenticata(false);
            properties.setContentStreamFilename("contentStreamProva");

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio query, entita "StatoDiEfficaciaDecodifica"
//            IdStatoDiEfficaciaType idStatoE = new IdStatoDiEfficaciaType();
//            idStatoE.setValue();
//            properties.setIdStatoDiEfficacia(idStatoE);

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio query, entita "FormaDocumentariaDecodifica"
//            IdFormaDocumentariaType idFormaDoc = new IdFormaDocumentariaType();
//            idFormaDoc.setValue();
//            properties.setIdFormaDocumentaria(idFormaDoc);

            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio managementService.getVitalRecordCode
            String vrcDescrizione = "medio";
            VitalRecordCodeType[] vrcArray = getServiziAcaris().getManagementServicePort().getVitalRecordCode(getRepositoryId());
            for (VitalRecordCodeType vrc : vrcArray) {
                if (vrcDescrizione.toUpperCase().equals(vrc.getDescrizione().toUpperCase())) {
                    properties.setIdVitalRecordCode(vrc.getIdVitalRecordCode());
                    break;
                }
            }

            // properties.setTipoDocFisico(EnumTipoDocumentoType.FIRMATO);
            properties.setTipoDocFisico(EnumTipoDocumentoType.SEMPLICE);
            // properties.setCodBarre("codiceBARRE");

            properties.setComposizione(EnumDocPrimarioType.DOCUMENTO_SINGOLO);
            properties.setMultiplo(false);

            ClassificazionePropertiesType associativeObjectProperties = new ClassificazionePropertiesType();
            // associativeObjectProperties.setNumeroInput("1234124");
            // valore indicato in sede di analisi archivistica
            associativeObjectProperties.setCopiaCartacea(false);

            properties.setRappresentazioneDigitale(true); // per doc elettronico
            associativeObjectProperties.setCollocazioneCartacea("locazione polverosa");
            // valore indicato in sede di analisi archivistica
            associativeObjectProperties.setCartaceo(true);

            // creazione contenuto fisico e relativo stream dati
            ContenutoFisicoIRC[] contenuti = new ContenutoFisicoIRC[1];
            contenuti[0] = new ContenutoFisicoIRC();
//            AcarisContentStreamType contentStream = TestUtils.creaContentStream("C:/path/to/", "prova.pdf", "pdf", EnumMimeTypeType.APPLICATION_PDF,
//                getServiziAcaris().isWS());
            AcarisContentStreamType contentStream = TestUtils.creaContentStream("files/", "prova.pdf", "pdf", EnumMimeTypeType.APPLICATION_PDF,
                getServiziAcaris().isMtomEnabled());
            contenuti[0].setStream(contentStream);
            contenuti[0].setTipo(EnumStreamId.PRIMARY);
            // contenuti[0].setTipo(EnumStreamId.SIGNATURE);
            contenuti[0].setAzioniVerificaFirma(TestUtils.getDatiTestAzioniVerificaFirma());

            ContenutoFisicoPropertiesType contenutoFisicoPropertiesType = new ContenutoFisicoPropertiesType();
            // definire a true per sbustare il contenuto fisico
            contenutoFisicoPropertiesType.setSbustamento(false);
            contenuti[0].setPropertiesContenutoFisico(contenutoFisicoPropertiesType);

            // creazione documento fisico
            DocumentoFisicoIRC[] documenti = new DocumentoFisicoIRC[1];
            documenti[0] = new DocumentoFisicoIRC();
            DocumentoFisicoPropertiesType documentoFisicoProperty = new DocumentoFisicoPropertiesType();
            documentoFisicoProperty.setDescrizione("documento fisico");
            documentoFisicoProperty.setDataMemorizzazione(new Date());
            documenti[0].setPropertiesDocumentoFisico(documentoFisicoProperty);
            documenti[0].setContenutiFisici(contenuti);
            documenti[0].setAzioniVerificaFirma(TestUtils.getDatiTestAzioniVerificaFirma());

            datiCreazione.setParentFolderId(parentFolder);
            datiCreazione.setTipoDocumento(EnumTipoDocumentoArchivistico.DOCUMENTO_SEMPLICE);
            datiCreazione.setPropertiesDocumento(properties);
            datiCreazione.setPropertiesClassificazione(associativeObjectProperties);
            datiCreazione.setDocumentiFisici(documenti);

            EnumTipoOperazione tipoOperazione = EnumTipoOperazione.ELETTRONICO;

            documentId = getServiziAcaris().getDocumentServicePort().creaDocumento(getRepositoryId(), getPrincipalId(), tipoOperazione, datiCreazione);
        } catch (it.doqui.acta.acaris.documentservice.AcarisException acEx) {
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (IOException e) {
            System.err.println("errore nella creazione del contentStream");
            e.printStackTrace();
            throw e;
        } catch (Exception ex) {
            System.err.println("errore nella classificazione del documento");
            ex.printStackTrace();
            throw ex;
        }

        return documentId;
    }

    public void classificaInAggregazione(ObjectIdType objectIdAggregazione, int nClassificazioni) throws Exception {
        if(objectIdAggregazione == null) {
            System.err.println("ObjectId nullo!");
            return;
        }
        
        System.out.println("creo classificazioni");
        for(int i = 0; i < nClassificazioni; i++)
            creaClassificazioneDefinitivaDocumentoElenttronico(objectIdAggregazione);
    }
    
    public static void main(String[] args) {
//        String codiceFruitore = "TESTSICUREZZA";
//        String codiceAmbiente = "PART228";
//        ChiudiVolume testCD = new ChiudiVolume(codiceFruitore, codiceAmbiente);
        ChiudiVolume testCD = new ChiudiVolume();
        
        System.out.println("********************** test chiudiVolume inizio");

        try {
            // objectId che identifica il volume, cercato tramite query su paroleChiave
            ObjectIdType aggregazioneParent = testCD.ricercaPerParolaChiave(EnumFolderObjectType.SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE, "parolaChiaveChiudiVolumeTest");
    
            if(aggregazioneParent != null) {
                ObjectIdType objectIdVolume = testCD.ricercaPerParolaChiave(EnumFolderObjectType.VOLUME_SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE, PAROLA_CHIAVE_VOLUME_STD);
                if(objectIdVolume == null)
                    objectIdVolume = testCD.creaVolumeSerieTipologicaDocumenti(aggregazioneParent);
                testCD.classificaInAggregazione(objectIdVolume, N_CLASSIFICAZIONI);
                testCD.chiudiAggregazione(objectIdVolume);
            } else 
                System.out.println("serie tipologica non trovata per parola chiave 'parolaChiaveChiudiVolumeTest'");
            
            System.out.println("test terminato");
        } catch (Exception e) {
            System.err.println("errore bloccante");
        }
    }
}
