package it.doqui.acta.actasrv.fruitori.esempi.objectService.createFolder;

import java.text.SimpleDateFormat;
import java.util.Date;

import it.doqui.acta.acaris.objectservice.AcarisException;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DossierPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumFolderObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdAOOType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdNodoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdStrutturaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.NavigationConditionInfoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.TestUtils;

public class CreaDossier {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;

    // utilizzare la configurazione trasmessa via mail sviluppo integrazione
    private final String COD_FISCALE = "";
    private final long ID_AOO = 0L;
    private final long ID_NODO = 0L;
    private final long ID_STRUTTURA = 0L;
    private final String APP_KEY = "";
    private final String REPOSITORY_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";

    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD

    private ConfigurazioneFruitore configurazione;
    private ObjectIdType repositoryId;
    private PrincipalIdType principalId;
    private String codiceVoce;
    private String descrizioneVoce;
    private String paroleChiaveSerie;
    private ObjectIdType objectIdDossier;

    public CreaDossier() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }
    
    public CreaDossier(ConfigurazioneFruitore configurazione) {
        this.configurazione = configurazione;
    }
    
    public void esegui() {
        // objectId che identifica il volume, cercato tramite query su paroleChiave
        String objectIdVoce = ricercaVoce(this.getCodiceVoce(), this.getDescrizioneVoce());

        if (objectIdVoce == null) {
            System.out.println("voce di titolario non trovata");
            return;
        }
        
        String objectIdSerie = ricercaSerieDossierPerParolaChiave(getParoleChiaveSerie(), objectIdVoce);

        if (objectIdSerie == null) {
            System.out.println("aggregazione padre non trovata");
            return;
        }
        
        ObjectIdType aggregazioneParent = new ObjectIdType();
        aggregazioneParent.setValue(objectIdSerie);
        this.setObjectIdDossier(creaDossier(aggregazioneParent));
    }

    private ObjectIdType creaDossier(ObjectIdType aggregazioneParent) {
        String metodo = "creaDossier";
        
        ObjectIdType result = null;
        try {
            String localDateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            // valorizzare i seguenti parametri in base all'analisi archivistica
            DossierPropertiesType dossierProperties = new DossierPropertiesType();
            dossierProperties.setCodice("ACARIS_DO");
            dossierProperties.setDescrizione("TST_ACARIS_" + localDateTime);
            dossierProperties.setConservazioneCorrente(1);
            dossierProperties.setConservazioneGenerale(99);
            dossierProperties.setDatiPersonali(true);
            dossierProperties.setDatiSensibili(false);
            dossierProperties.setDatiRiservati(false);
            dossierProperties.setParoleChiave("TST_ACARIS_DO_" + localDateTime);
            IdAOOType idAoo = new IdAOOType();
            idAoo.setValue(getParametri().getIdAoo());
            dossierProperties.setIdAOORespMat(idAoo);
            IdStrutturaType idStruttura = new IdStrutturaType();
            idStruttura.setValue(getParametri().getIdStruttura());
            dossierProperties.setIdStrutturaRespMat(idStruttura);
            IdNodoType idNodo = new IdNodoType();
            idNodo.setValue(getParametri().getIdNodo());
            dossierProperties.setIdNodoRespMat(idNodo);
            dossierProperties.setCreazioneFascicoli(true);
            dossierProperties.setRiclassificazioneFascicoli(false);
            dossierProperties.setAggiuntaOriClassificazioneDocumenti(true);
            
            EnumFolderObjectType typeId = EnumFolderObjectType.DOSSIER_PROPERTIES_TYPE;

            result = getServiziAcaris().getObjectServicePort().createFolder(getRepositoryId(), typeId, getPrincipalId(),
                dossierProperties, aggregazioneParent);

            if (result != null) {
                System.out.println(metodo + ": Aggregazione creata, objectId: " + result.getValue());
            }
        } catch (AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
        } catch (Exception e) {
            System.err.println(metodo + ": errore generico");
            e.printStackTrace();
        }
        
        return result;
    }

    // ricerca voce con codice e descrizione breve
    private String ricercaVoce(String codiceVoce, String descrizione) {
        String metodo = "ricercaVoce";
        
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumObjectType.VOCE_PROPERTIES_TYPE.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.ALL);

        QueryConditionType[] criteria = new QueryConditionType[2];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("codice");
        criteria[0].setOperator(EnumQueryOperator.EQUALS);
        criteria[0].setValue(codiceVoce);
        criteria[1] = new QueryConditionType();
        criteria[1].setPropertyName("descrBreve");
        criteria[1].setOperator(EnumQueryOperator.EQUALS);
        criteria[1].setValue(descrizione);

        NavigationConditionInfoType navigationConditionInfo = null;
        Integer maxItems = null;
        Integer skipCount = null;
        System.out.println("ricerca voce titolario con codice " + codiceVoce);

        String objectIdVoce = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target,
                filter, criteria, navigationConditionInfo, maxItems, skipCount);

            if (result == null || result.getObjectsLength() == 0) {
                throw new Exception("query errata: nessun risultato!");
            }
            
            if (result.getObjectsLength() > 1) {
                throw new Exception("query errata: trovati risultati multipli!");
            }
            
            if (result.getObjects(0) == null || result.getObjects(0).getPropertiesLength() == 0) {
                throw new Exception("query errata: restituito oggetto nullo?! contattare assistenza");
            }
            
            for (PropertyType current : result.getObjects(0).getProperties()) {
                if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                    && current.getValue().getContentLength() == 1) {
                    objectIdVoce = current.getValue().getContent(0);
                    break;
                }
            }

            if (objectIdVoce == null) {
                throw new Exception("query errata!");
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
        } catch (Exception e) {
            System.err.println(metodo + ": errore generico");
            e.printStackTrace();
        }

        return objectIdVoce;
    }

    private String ricercaSerieDossierPerParolaChiave(String parolaChiave, String objectIdVoce) {
        String metodo = "ricercaSerieDossierPerParolaChiave";
        
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumObjectType.SERIE_DOSSIER_PROPERTIES_TYPE.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.NONE);

        QueryConditionType[] criteria = new QueryConditionType[1];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("paroleChiave");
        criteria[0].setOperator(EnumQueryOperator.EQUALS); //ricerca della parola chiave ESATTA
//      criteria[0].setOperator(EnumQueryOperator.LIKE); //ricerca della parola chiave CON WILDCARD * (fruitore deve specificare)
        criteria[0].setValue(parolaChiave);

        NavigationConditionInfoType navigationInfo = new NavigationConditionInfoType();
        ObjectIdType parentObjectId = new ObjectIdType();
        parentObjectId.setValue(objectIdVoce);
        navigationInfo.setParentNodeId(parentObjectId);
        Integer maxItems = Integer.valueOf(5);

        String objectIdSerie = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target,
                    filter, criteria, navigationInfo, maxItems, null);

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null
                    && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                            && current.getValue().getContentLength() == 1) {
                        objectIdSerie = current.getValue().getContent(0);
                        break;
                    }
                }

                if (objectIdSerie == null) {
                    throw new Exception("query errata!");
                }

            } else {
                throw new Exception("query errata!");
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return objectIdSerie;
    }
    
    private ObjectIdType getRepositoryId() {
        if (repositoryId == null) {
            repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
        }
        return repositoryId;
    }

    private PrincipalIdType getPrincipalId() {
        if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
        }

        return principalId;
    }
    
    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }

    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }

    public String getCodiceVoce() {
        return codiceVoce;
    }

    public void setCodiceVoce(String codiceVoce) {
        this.codiceVoce = codiceVoce;
    }

    public String getDescrizioneVoce() {
        return descrizioneVoce;
    }

    public void setDescrizioneVoce(String descrizioneVoce) {
        this.descrizioneVoce = descrizioneVoce;
    }

    public String getParoleChiaveSerie() {
        return paroleChiaveSerie;
    }

    public void setParoleChiaveSerie(String paroleChiaveSerie) {
        this.paroleChiaveSerie = paroleChiaveSerie;
    }

    public ObjectIdType getObjectIdDossier() {
        return objectIdDossier;
    }

    public void setObjectIdDossier(ObjectIdType objectIdDossier) {
        this.objectIdDossier = objectIdDossier;
    }
    
    public static void main(String[] args) {
        System.out.println("\n ********************** " + CreaDossier.class.getSimpleName() + " inizio");
        
        CreaDossier test = new CreaDossier();

        String codiceVoce = "";
        test.setCodiceVoce(codiceVoce);
        String descrizioneVoce = "";
        test.setDescrizioneVoce(descrizioneVoce);
        String paroleChiaveSerie = "";
        test.setParoleChiaveSerie(paroleChiaveSerie);
        test.esegui();
        
        System.out.println("\n ********************** " + CreaDossier.class.getSimpleName() + " fine");
    }
}
