package it.doqui.acta.actasrv.fruitori.esempi.objectService.createFolder;

import java.text.SimpleDateFormat;
import java.util.Date;

import it.doqui.acta.acaris.objectservice.AcarisException;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumFolderObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.FascicoloRealeAnnualePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdAOOType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdNodoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdStrutturaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdVitalRecordCodeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.NavigationConditionInfoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.management.VitalRecordCodeType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.TestUtils;

public class CreaFascicolo {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;

    // utilizzare la configurazione trasmessa via mail sviluppo integrazione
    private final String COD_FISCALE = "";
    private final long ID_AOO = 0L;
    private final long ID_NODO = 0L;
    private final long ID_STRUTTURA = 0L;
    private final String APP_KEY = "";
    private final String REPOSITORY_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";

    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD

    private ConfigurazioneFruitore configurazione;
    private ObjectIdType repositoryId;
    private PrincipalIdType principalId;
    private String descrizioneVoce;
    private String codiceVoce;
    private ObjectIdType objectIdFascicolo;

    public CreaFascicolo() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }
    
    public CreaFascicolo(ConfigurazioneFruitore configurazione) {
        this.configurazione = configurazione;
    }

    public void esegui() {
        // objectId che identifica il volume, cercato tramite query su paroleChiave
        String objectIdVoce = ricercaVoce(this.getCodiceVoce(), this.getDescrizioneVoce());

        if (objectIdVoce == null) {
            System.out.println("aggregazione padre non trovata");
            return;
        }

        ObjectIdType aggregazioneParent = new ObjectIdType();
        aggregazioneParent.setValue(objectIdVoce);
        this.setObjectIdFascicolo(creaFascicoloAnnuale(aggregazioneParent));
    }
    
    private ObjectIdType creaFascicoloAnnuale(ObjectIdType aggregazioneParent) {
        String metodo = "creaFascicoloAnnuale";
        
        ObjectIdType result = null;
        try {
            // impostare il tipo di fascicolo che si vuole creare tra quelli a disposizione
            // in base a quanto indicato in analisi archivistica
            // Utilizzare EnumFolderObjectType per conoscere i tipi di fascicoli disponibili

            String localDateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            // valorizzare i seguenti parametri in base all'analisi archivistica
            // utilizzare la property corrispondente al typeId utilizzato
            FascicoloRealeAnnualePropertiesType fascicoloProperties = new FascicoloRealeAnnualePropertiesType();
            fascicoloProperties.setOggetto("test acaris " + localDateTime);
            fascicoloProperties.setConservazioneCorrente(1);
            fascicoloProperties.setConservazioneGenerale(99);
            fascicoloProperties.setDatiPersonali(true);
            fascicoloProperties.setDatiSensibili(false);
            fascicoloProperties.setDatiRiservati(false);
            fascicoloProperties.setParoleChiave("TST_ACARIS_FRA_" + localDateTime);
            IdAOOType idAoo = new IdAOOType();
            idAoo.setValue(getParametri().getIdAoo());
            fascicoloProperties.setIdAOORespMat(idAoo);
            IdStrutturaType idStruttura = new IdStrutturaType();
            idStruttura.setValue(getParametri().getIdStruttura());
            fascicoloProperties.setIdStrutturaRespMat(idStruttura);
            IdNodoType idNodo = new IdNodoType();
            idNodo.setValue(getParametri().getIdNodo());
            fascicoloProperties.setIdNodoRespMat(idNodo);

            String value = "alto"; // indicare il valore richiesto (indicato in analisi archivistica)
            IdVitalRecordCodeType idVitalRecordCode = null;
            VitalRecordCodeType[] vrcArray = getVitalRecordCode();
            for (VitalRecordCodeType vrc : vrcArray) {
                if (vrc.getDescrizione().equalsIgnoreCase(value)) {
                    idVitalRecordCode = vrc.getIdVitalRecordCode();
                    break;
                }
            }

            fascicoloProperties.setIdVitalRecordCode(idVitalRecordCode);
            
            EnumFolderObjectType typeId = EnumFolderObjectType.FASCICOLO_REALE_ANNUALE_PROPERTIES_TYPE;

            result = getServiziAcaris().getObjectServicePort().createFolder(getRepositoryId(), typeId, getPrincipalId(),
                fascicoloProperties, aggregazioneParent);

            if (result != null) {
                System.out.println(metodo + ": Aggregazione creata, objectId: " + result.getValue());
            }

        } catch (AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
        } catch (Exception e) {
            System.err.println(metodo + ": errore generico");
            e.printStackTrace();
        }

        return result;
    }

    private VitalRecordCodeType[] getVitalRecordCode() throws Exception {
        String metodo = "getVitalRecordCode";
        
        VitalRecordCodeType[] results = new VitalRecordCodeType[0];
        long start = System.currentTimeMillis();
        try {
            results = getServiziAcaris().getManagementServicePort().getVitalRecordCode(getRepositoryId());
        } catch (it.doqui.acta.acaris.managementservice.AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
            throw acEx;
        } catch (Exception ex) {
            System.err.println(metodo + ": errore generico");
            ex.printStackTrace();
            throw ex;
        } finally {
            System.out.println(metodo + ": elapsed time " + (System.currentTimeMillis() - start) + " ms");
        }

        return results;
    }

    // ricerca voce con codice e descrizione breve
    private String ricercaVoce(String codiceVoce, String descrizione) {
        String metodo = "ricercaVoce";
        
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumObjectType.VOCE_PROPERTIES_TYPE.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.ALL);

        QueryConditionType[] criteria = new QueryConditionType[2];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("codice");
        criteria[0].setOperator(EnumQueryOperator.EQUALS);
        criteria[0].setValue(codiceVoce);
        criteria[1] = new QueryConditionType();
        criteria[1].setPropertyName("descrBreve");
        criteria[1].setOperator(EnumQueryOperator.EQUALS);
        criteria[1].setValue(descrizione);

        NavigationConditionInfoType navigationConditionInfo = null;
        Integer maxItems = null;
        Integer skipCount = null;
        System.out.println("ricerca voce titolario con codice " + codiceVoce);

        String objectIdVoce = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target,
                filter, criteria, navigationConditionInfo, maxItems, skipCount);

            if (result == null || result.getObjectsLength() == 0) {
                throw new Exception("query errata: nessun risultato!");
            }
            
            if (result.getObjectsLength() > 1) {
                throw new Exception("query errata: trovati risultati multipli!");
            }
            
            if (result.getObjects(0) == null || result.getObjects(0).getPropertiesLength() == 0) {
                throw new Exception("query errata: restituito oggetto nullo?! contattare assistenza");
            }
            
            for (PropertyType current : result.getObjects(0).getProperties()) {
                if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                    && current.getValue().getContentLength() == 1) {
                    objectIdVoce = current.getValue().getContent(0);
                    break;
                }
            }

            if (objectIdVoce == null) {
                throw new Exception("query errata!");
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return objectIdVoce;
    }

    private ObjectIdType getRepositoryId() {
        if (repositoryId == null) {
            repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
        }
        return repositoryId;
    }

    private PrincipalIdType getPrincipalId() {
        if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
        }

        return principalId;
    }

    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }

    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }

    public String getDescrizioneVoce() {
        return descrizioneVoce;
    }

    public void setDescrizioneVoce(String descrizioneVoce) {
        this.descrizioneVoce = descrizioneVoce;
    }

    public String getCodiceVoce() {
        return codiceVoce;
    }

    public void setCodiceVoce(String codiceVoce) {
        this.codiceVoce = codiceVoce;
    }

    public ObjectIdType getObjectIdFascicolo() {
        return objectIdFascicolo;
    }

    public void setObjectIdFascicolo(ObjectIdType objectIdFascicolo) {
        this.objectIdFascicolo = objectIdFascicolo;
    }

    public static void main(String[] args) {
        System.out.println("\n ********************** " + CreaFascicolo.class.getSimpleName() + " inizio");
        
        CreaFascicolo test = new CreaFascicolo();
        String codiceVoce = "";
        test.setCodiceVoce(codiceVoce);
        String descrizioneVoce = "";
        test.setDescrizioneVoce(descrizioneVoce);
        test.esegui();
        
        System.out.println("\n ********************** " + CreaFascicolo.class.getSimpleName() + " fine");
    }
}
