package it.doqui.acta.actasrv.fruitori.esempi.objectService.createFolder;

import it.doqui.acta.acaris.objectservice.AcarisException;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumFolderObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.VolumeSerieTipologicaDocumentiPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.TestUtils;

public class CreaVolume {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;
    
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private final String COD_FISCALE = "";
    private final long ID_AOO = 0L;
    private final long ID_NODO = 0L;
    private final long ID_STRUTTURA = 0L;
    private final String APP_KEY = "";
    private final String REPOSITORY_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";
    
    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD
    
    private ConfigurazioneFruitore configurazione;
    private ObjectIdType repositoryId;
    private PrincipalIdType principalId;
    private String paroleChiaveSerie;
    private Object objectIdVolume;
    
    public CreaVolume() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }
    
    public CreaVolume(ConfigurazioneFruitore configurazione) {
        this.configurazione = configurazione;
    }

    public void esegui() {
        // objectId che identifica il volume, cercato tramite query su paroleChiave
        String objectIdSerie = ricercaSeriePerParolaChiave(getParoleChiaveSerie());

        if (objectIdSerie == null) {
            System.out.println("serie tipologica non trovata per parola chiave '" + getParoleChiaveSerie() + "'");
            return;
        }
        
        ObjectIdType aggregazioneParent = new ObjectIdType();
        aggregazioneParent.setValue(objectIdSerie);
        this.setObjectIdVolume(creaVolumeSerieTipologicaDocumenti(aggregazioneParent));
    }
    
	public ObjectIdType creaVolumeSerieTipologicaDocumenti(ObjectIdType aggregazioneParent) {
	    String metodo = "creaVolumeSerieTipologicaDocumenti";
	    
		ObjectIdType result = null;
		
		try {
//			impostare il tipo di volume che si vuole creare tra quelli a disposizione
//			in base a quanto indicato in analisi archivistica
//			Utilizzare EnumFolderObjectType	per conoscere i tipi di volumi disponibili
			EnumFolderObjectType typeId = EnumFolderObjectType.VOLUME_SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE;

//			utilizzare la property corrispondente al typeId utilizzato
//			propertyesType disponibili:
//				VolumeFascicoliPropertiesType.class
//				VolumeSerieFascicoliPropertiesType.class
//				VolumeSottofascicoliPropertiesType.class
//				VolumeSerieTipologicaDocumentiPropertiesType.class
			VolumeSerieTipologicaDocumentiPropertiesType volumeSerieProperties = new VolumeSerieTipologicaDocumentiPropertiesType();

			//valorizzare i seguenti parametri in base all'analisi archivistica
			volumeSerieProperties.setConservazioneCorrente(1);
			volumeSerieProperties.setConservazioneGenerale(2);
			volumeSerieProperties.setCollocazioneCartaceo("Collocazione cartacea fittizia");
			volumeSerieProperties.setDescrizione("Volume creato via acaris");
			volumeSerieProperties.setParoleChiave("parola_chiave_volume_std");

			result = getServiziAcaris().getObjectServicePort().createFolder(getRepositoryId(), typeId, getPrincipalId(),
					volumeSerieProperties, aggregazioneParent);

			if(result != null) {
			    System.out.println(metodo + ": Aggregazione creata, objectId: " + result.getValue());
			}
		} catch (AcarisException acEx) {
		    TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
		} catch (Exception e) {
            System.err.println(metodo + ": errore generico");
            e.printStackTrace();
        }
		
		return result;
	}
	
	private String ricercaSeriePerParolaChiave(String parolaChiave) {
	    String metodo = "ricercaSeriePerParolaChiave";
	    
		QueryableObjectType target = new QueryableObjectType();
		target.setObject(EnumObjectType.SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE.value());

		PropertyFilterType filter = new PropertyFilterType();
		filter.setFilterType(EnumPropertyFilter.NONE);

		QueryConditionType[] criteria = new QueryConditionType[1];
		criteria[0] = new QueryConditionType();
		criteria[0].setPropertyName("paroleChiave");
        criteria[0].setOperator(EnumQueryOperator.EQUALS); //ricerca della parola chiave ESATTA
//      criteria[0].setOperator(EnumQueryOperator.LIKE); //ricerca della parola chiave CON WILDCARD * (fruitore deve specificare)
		criteria[0].setValue(parolaChiave);

		Integer maxItems = new Integer(5);

		String objectIdSerie = null;
		try {
			PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target,
					filter, criteria, null, maxItems, null);

			if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null
					&& result.getObjects(0).getPropertiesLength() > 0) {
				for (PropertyType current : result.getObjects(0).getProperties()) {
					if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
							&& current.getValue().getContentLength() == 1) {
						objectIdSerie = current.getValue().getContent(0);
						break;
					}
				}

				if (objectIdSerie == null) {
					throw new Exception("query errata!");
				}

			} else {
				throw new Exception("query errata!");
			}

		} catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
		    TestUtils.printAcarisException(metodo, acEx.getMessage(), acEx.getFaultInfo());
		} catch (Exception e) {
			e.printStackTrace();
		}

		return objectIdSerie;
	}

	private ObjectIdType getRepositoryId() {
		if (repositoryId == null) {
			repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
		}
		return repositoryId;
	}

	private PrincipalIdType getPrincipalId() {
		if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
		}
		
		return principalId;
	}
	
    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }
    
    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }

    public String getParoleChiaveSerie() {
        return paroleChiaveSerie;
    }

    public void setParoleChiaveSerie(String paroleChiaveSerie) {
        this.paroleChiaveSerie = paroleChiaveSerie;
    }

    public Object getObjectIdVolume() {
        return objectIdVolume;
    }

    public void setObjectIdVolume(Object objectIdVolume) {
        this.objectIdVolume = objectIdVolume;
    }
	
	public static void main(String[] args) {
	    System.out.println("\n ********************** " + CreaVolume.class.getSimpleName() + " inizio");

		CreaVolume testCD = new CreaVolume();
		
		String paroleChiave = "";
		testCD.setParoleChiaveSerie(paroleChiave);
		testCD.esegui();
		
		System.out.println("\n ********************** " + CreaVolume.class.getSimpleName() + " fine");
	}
}
