package it.doqui.acta.actasrv.fruitori.esempi.objectService.query;

import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.NavigationConditionInfoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.TestUtils;

public class RicercaSeriePerParolaChiave {

    private final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private final String PART228_CONTEXT = "actasrv";
    private final int PART228_PORT = 80;
    
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private final String COD_FISCALE = "";
    private final long ID_AOO = 0L;
    private final long ID_NODO = 0L;
    private final long ID_STRUTTURA = 0L;
    private final String APP_KEY = "";
    private final String REPOSITORY_NAME = "RP201209 Regione Piemonte - Agg. 09/2012";
    
    private final static boolean MTOM_ENABLED = false; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD

    private ConfigurazioneFruitore configurazione;
    
    public RicercaSeriePerParolaChiave() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
    }

    private ServiziAcaris getServiziAcaris() {
        return this.configurazione.getServiziAcaris();
    }
    
    private ParametriAcaris getParametri() {
        return this.configurazione.getParametri();
    }
    
    public static void main(String[] args) {

        RicercaSeriePerParolaChiave testRicerca = new RicercaSeriePerParolaChiave();

        System.out.println("\n ********************** query inizio");

        /**********************************************************************************************************
         * repository
         *********************************************************************************************************/

        ObjectIdType repositoryId = testRicerca.getServiziAcaris().getRepositoryId(testRicerca.getParametri().getRepositoryName());

        /**********************************************************************************************************
         * ATTENZIONE: codice fiscale e tripletta di identificatori per ottenere
         * il principal DEVONO essere quelli dell'utente di test usato dal
         * verticale nel repository di interesse
         * 
         * Dati da utilizzare sono stati indicati via mail
         *********************************************************************************************************/

        PrincipalIdType principalId = testRicerca.getServiziAcaris().getPrincipalExt(repositoryId, testRicerca.getParametri().getCodiceFiscale(),
            testRicerca.getParametri().getIdAoo(), testRicerca.getParametri().getIdStruttura(), testRicerca.getParametri().getIdNodo(),
            testRicerca.getParametri().getAppKey());

        /**********************************************************************************************************
         * target
         *********************************************************************************************************/

        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumObjectType.SERIE_TIPOLOGICA_DOCUMENTI_PROPERTIES_TYPE.value());

        /**********************************************************************************************************
         * propertyFilter
         *********************************************************************************************************/
        // RACCOMANDATO usare LIST invece di ALL
        PropertyFilterType filter = TestUtils.getPropertyFilterAll();

        /**********************************************************************************************************
         * criteria
         *********************************************************************************************************/

        QueryConditionType[] criteria = TestUtils.getCriteria(
            new EnumQueryOperator[] { EnumQueryOperator.EQUALS }, 
            // ricerca della parola chiave ESATTA
            new String[] { "paroleChiave" }, new String[] { "parola-chiave-aggregazione" } // parola chiave ESATTA

            // EnumQueryOperator.LIKE -> ricerca della parola chiave CON WILDCARD * (fruitore deve specificare)
            // new EnumQueryOperator[] { EnumQueryOperator.LIKE }, 
            // parola chiave CON WILDCARD * (es. match con "parola-chiave-aggregazione-223465")
            // new String[] { "parola-chiave-aggregazione*" } 
        );

        /**********************************************************************************************************
         * paginazione
         *********************************************************************************************************/

        NavigationConditionInfoType navigationLimits = new NavigationConditionInfoType();
        navigationLimits.isLimitToChildren();

        // con queste impostazioni la paginazione  gestita direttamente dal sistema
        Integer maxItems = null;
        Integer skipCount = 0;

        /**********************************************************************************************************
         * invocazione servizio query
         *********************************************************************************************************/
        PagingResponseType pagingResponse = new PagingResponseType();

        try {
            pagingResponse = testRicerca.getServiziAcaris().getObjectServicePort().query(repositoryId, principalId, target, filter, criteria, null, maxItems,
                skipCount);
        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("errore sollevato dal servizio query");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            System.err.println("acEx.getFaultInfo().getTechnicalInfo: " + acEx.getFaultInfo().getTechnicalInfo());
        } catch (Exception ex) {
            System.err.println("errore sollevato dal servizio query");
            ex.printStackTrace();
        }

        if (pagingResponse != null && pagingResponse.getObjects().length > 0) {
            System.out.println(" pagingResponse.length = " + pagingResponse.getObjects().length);
            System.out.println(" hasMoreItems = " + pagingResponse.isHasMoreItems());
            TestUtils.stampa(pagingResponse);
        } else {
            System.out.println(" nessun risultato trovato");
        }

        System.out.println("\n ********************** query fine");
    }
}
