package it.doqui.acta.actasrv.fruitori.esempi.officialbookService.creaRegistrazione;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.activation.DataHandler;

import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;

import it.doqui.acta.actasrv.dto.acaris.type.archive.ClassificazionePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ContenutoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoSemplicePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumDocPrimarioType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumTipoDocumentoType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.GruppoAllegatiPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.IdFormaDocumentariaType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.IdStatoDiEfficaciaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisContentStreamType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumErrorCodeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumMimeTypeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumStreamId;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdVitalRecordCodeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryNameType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.prt.EnumPFPGUL;
import it.doqui.acta.actasrv.dto.acaris.type.document.ContenutoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoArchivisticoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumStepErrorAction;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoDocumentoArchivistico;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoOperazione;
import it.doqui.acta.actasrv.dto.acaris.type.document.IdentificatoreDocumento;
import it.doqui.acta.actasrv.dto.acaris.type.management.VitalRecordCodeType;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.DestinatarioInterno;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.EnumTipoAPI;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.EnumTipoRegistrazioneDaCreare;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.EnumTipologiaSoggettoAssociato;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.IdentificazioneProtocollante;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.IdentificazioneRegistrazione;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.InfoCreazioneCorrispondente;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.InfoCreazioneRegistrazione;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.MittenteEsterno;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.ProtocollazioneDocumentoEsistente;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.RegistrazioneArrivo;
import it.doqui.acta.actasrv.dto.acaris.type.officialbook.RiferimentoSoggettoEsistente;
import it.doqui.acta.actasrv.dto.acaris.type.subjectregistry.EnumRegistryObjectType;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;

public class CreaRegistrazioneDaDocEsistenti {

    private static final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private static final String PART228_CONTEXT = "actasrv";
    private static final int PART228_PORT = 80;
            
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private static final String COD_FISCALE = "";
    private static final long ID_AOO = 0L;
    private static final long ID_NODO = 0L;
    private static final long ID_STRUTTURA = 0L;
    private static final String APP_KEY = "";
    private static final String CODICE_ENTE = "RP201209";
    private static final String DESCRIZIONE_ENTE = "Regione Piemonte - Agg. 09/2012";
    private static final String REPOSITORY_NAME = CODICE_ENTE + " " + DESCRIZIONE_ENTE;
            
    private static final boolean MTOM_ENABLED = 
        true; // se si effettua invocazione via WS
        // false; //se si effettua invocazione via PAPD
    
    private ParametriAcaris parametri;
    private ServiziAcaris serviziAcaris;
    
    private ObjectIdType repositoryId;
    private PrincipalIdType principalId;

    private static final int N_CLASSIFICAZIONI_ALLEGATE = 20;
    private static final String FILE_FOLDER_PATH = "files" + File.separatorChar;

    public CreaRegistrazioneDaDocEsistenti() {
        this(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_STRUTTURA, ID_NODO, APP_KEY);
    }
       
    public CreaRegistrazioneDaDocEsistenti(String server, String context, int port, String repository, String cf, long idAoo, long idStruttura, long idNodo, 
        String appKey) {
        parametri = new ParametriAcaris(server, context, port);
        parametri.setRepositoryName(repository);
        parametri.setCodiceFiscale(cf);
        parametri.setIdAoo(idAoo);
        parametri.setIdNodo(idNodo);
        parametri.setIdStruttura(idStruttura);
        parametri.setAppKey(appKey);
        serviziAcaris = new ServiziAcaris(parametri.getServer(), parametri.getContext(), parametri.getPort(), MTOM_ENABLED);
    }

    public IdentificazioneRegistrazione protocollazioneDocEsistenteInArrivo(ObjectIdType classificazioneId) throws Exception {

        EnumTipoRegistrazioneDaCreare tipologiaCreazione = EnumTipoRegistrazioneDaCreare.PROTOCOLLAZIONE_DOCUMENTO_ESISTENTE;

        // oggetti recuperabili dal servizio query dell'interfaccia backofficeservice
        ObjectIdType idAoo = queryFor(EnumObjectType.AOO_PROPERTIES_TYPE, getParametri().getIdAoo());
        ObjectIdType idStruttura = queryFor(EnumObjectType.NODO_PROPERTIES_TYPE, getParametri().getIdStruttura());
        ObjectIdType idNodo = queryFor(EnumObjectType.STRUTTURA_PROPERTIES_TYPE, getParametri().getIdNodo());

        // tipo di registrazione: in arrivo
        RegistrazioneArrivo regArrivo = new RegistrazioneArrivo();
        regArrivo.setTipoRegistrazione(EnumTipoAPI.ARRIVO);
        // oggetto che contiene tutti i dati per impostare la registrazione
        InfoCreazioneRegistrazione infoCreazioneRegistrazione = new InfoCreazioneRegistrazione();
        regArrivo.setInfoCreazione(infoCreazioneRegistrazione);
        infoCreazioneRegistrazione.setForzareSePresenzaInviti(Boolean.TRUE);
        infoCreazioneRegistrazione.setForzareSePresenzaDaInoltrare(Boolean.TRUE);
        infoCreazioneRegistrazione.setForzareSeRegistrazioneSimile(Boolean.TRUE);

        // valorizzazione dei campi della registrazione
        
        // protocollante
        IdentificazioneProtocollante idProtocollante = new IdentificazioneProtocollante();
        idProtocollante.setStrutturaId(idStruttura); // da valorizzare con la struttura del protocollante
        idProtocollante.setNodoId(idNodo);// da valorizzare con il nodo del protocollante
        infoCreazioneRegistrazione.setProtocollante(idProtocollante);

        infoCreazioneRegistrazione.setOggetto("[DOC ESISTENTE] test fruitore creaRegistrazione");

        // creazione mittente esterno
        MittenteEsterno[] mEsterno = new MittenteEsterno[1];
        MittenteEsterno mittEsterno = new MittenteEsterno();
        InfoCreazioneCorrispondente infoCreazioneCorrispondenteMittente = new InfoCreazioneCorrispondente();
        infoCreazioneCorrispondenteMittente.setCognome("Rossi");
        infoCreazioneCorrispondenteMittente.setNome("Mario");

        // mittente: persona fisica
        RiferimentoSoggettoEsistente infoMittente = null;
        ObjectIdType soggettoActa = recuperaSoggettoActa("RSSMRA83D22L219C"); // cf fittizio, non presente in anagrafica
        // per questo test, effettuare protocollazione anche se cf non presente
        // a discrezione del fruitore acaris se il soggetto deve essere esistente in anagrafica
        // e' possibile creare una registrazione senza che il soggetto sia un soggetto in anagrafica acta
        if(soggettoActa != null) {
            infoMittente = new RiferimentoSoggettoEsistente();
            infoMittente.setSoggettoId(soggettoActa);
            infoMittente.setIdPFPGUL(EnumPFPGUL.PF);
            infoMittente.setTipologia(EnumTipologiaSoggettoAssociato.SOGGETTO_ACTA);
        }
        infoCreazioneCorrispondenteMittente.setInfoSoggettoAssociato(infoMittente);

        mittEsterno.setCorrispondente(infoCreazioneCorrispondenteMittente);
        mEsterno[0] = mittEsterno;

        regArrivo.setMittenteEsterno(mEsterno);

        // creazione destinatario interno
        // destinatario: nodo esistente
        RiferimentoSoggettoEsistente infoSoggetto = new RiferimentoSoggettoEsistente();
        infoSoggetto.setTipologia(EnumTipologiaSoggettoAssociato.NODO);
        infoSoggetto.setSoggettoId(idNodo);
        InfoCreazioneCorrispondente infoCreazioneCorrispondenteDestinatario = new InfoCreazioneCorrispondente();
        infoCreazioneCorrispondenteDestinatario.setInfoSoggettoAssociato(infoSoggetto);
        infoCreazioneCorrispondenteDestinatario.setDenominazione(queryForDescrizioneNodo(getParametri().getIdNodo()));
        DestinatarioInterno[] dInterno = new DestinatarioInterno[1];
        DestinatarioInterno destInterno = new DestinatarioInterno();
        destInterno.setCorrispondente(infoCreazioneCorrispondenteDestinatario);
        destInterno.setIdRuoloCorrispondente(1); // per competenza
        // destInterno.setIdRuoloCorrispondente(2); //per quanto di competenza
        // destInterno.setIdRuoloCorrispondente(3); //per conoscenza
        dInterno[0] = destInterno;
        infoCreazioneRegistrazione.setDestinatarioInterno(dInterno);

        ProtocollazioneDocumentoEsistente protocollazione = new ProtocollazioneDocumentoEsistente();
        protocollazione.setAooProtocollanteId(idAoo);
        protocollazione.setSenzaCreazioneSoggettiEsterni(true);
        protocollazione.setClassificazioneId(classificazioneId);
        protocollazione.setRegistrazioneAPI(regArrivo);

        IdentificazioneRegistrazione result = null;

        try {
            result = getServiziAcaris().getOfficialBookServicePort().creaRegistrazione(getRepositoryId(), getPrincipalId(), tipologiaCreazione,
                protocollazione);

        } catch (it.doqui.acta.acaris.officialbookservice.AcarisException acEx) {
            System.err.println("errore in creazione registrazione di protocollo");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
        } catch (Exception e) {
            System.err.println("errore generico in creazione registrazione di protocoollo");
        }

        return result;
    }

    public IdentificatoreDocumento creaDocumentoElettronicoNonFirmato(ObjectIdType parentFolder, ObjectIdType classificazionePrincipale) throws Exception {

        IdentificatoreDocumento documentId = null;

        DocumentoArchivisticoIRC datiCreazione = new DocumentoArchivisticoIRC();
        datiCreazione.setTipoDocumento(EnumTipoDocumentoArchivistico.DOCUMENTO_SEMPLICE);
        datiCreazione.setPropertiesClassificazione(creaClassificazionePropertiesType());
        datiCreazione.setPropertiesDocumento(creaDocumentoSemplicePropertiesType(parentFolder == null));

        if (parentFolder != null) {
            // si vuole creare una classificazione principale
            
            // info obbligatoria nel caso di creazione di un doc principale
            datiCreazione.setParentFolderId(parentFolder); 

            // per questo esempio, creiamo una classificazione con un gruppo allegati... non e' obbligatorio averne uno
            ((DocumentoSemplicePropertiesType) datiCreazione.getPropertiesDocumento()).setDocConAllegati(true);
            GruppoAllegatiPropertiesType gruppoAllegati = new GruppoAllegatiPropertiesType();
            gruppoAllegati.setNumeroAllegati(1); // numero massimo di allegati inseribili
            gruppoAllegati.setDataInizio(new Date());
            datiCreazione.setGruppoAllegati(gruppoAllegati);
        } else {
            // si vuole creare una classificazione allegata a un principale
            // in questo caso, classificazionePrincipale deve essere valorizzato
            datiCreazione.setAllegato(true);
            datiCreazione.setClassificazionePrincipale(classificazionePrincipale);
        }


        try {
            datiCreazione.setDocumentiFisici(creaDocumentoFisicoIRC());

            documentId = getServiziAcaris().getDocumentServicePort().creaDocumento(getRepositoryId(), getPrincipalId(), EnumTipoOperazione.ELETTRONICO,
                datiCreazione);
        } catch (it.doqui.acta.acaris.documentservice.AcarisException acEx) {
            System.err.println("errore in classificazione documento");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
        } catch (IOException e) {
            System.err.println("errore nella creazione del contenuto fisico");
            e.printStackTrace();
        } catch (Exception ex) {
            System.err.println("errore in classificazione documento");
            ex.printStackTrace();
        }

        if (documentId != null) {
            System.out.println("Classificazione creata con successo");
            stampa(documentId);
        }

        return documentId;
    }

    private DocumentoSemplicePropertiesType creaDocumentoSemplicePropertiesType(boolean isAllegato) throws Exception {
        DocumentoSemplicePropertiesType properties = new DocumentoSemplicePropertiesType();

        properties.setRegistrato(true);
        properties.setDefinitivo(true);
        properties.setModificabile(false);

        properties.setOrigineInterna(true);
        properties.setAnalogico(false);
        properties.setDaConservare(false);
        properties.setProntoPerConservazione(false);
        properties.setDaConservarePrimaDel(null);
        properties.setDatiPersonali(true);
        properties.setDatiRiservati(false);
        properties.setDatiSensibili(false);
        properties.setParoleChiave("test-creaRegistrazione-acaristeam");
        String[] autore = { "pippo|PPPPPP80A01L219I", "topolino|TPLMCK17A01L219B" };
        properties.setAutoreGiuridico(autore);
        properties.setAutoreFisico(autore);
        properties.setScrittore(autore);
        properties.setOriginatore(autore);
        properties.setDestinatarioGiuridico(autore);
        properties.setDestinatarioFisico(autore);
        properties.setOggetto("test crea registrazione");
        // properties.setOggetto(null);
        properties.setDataDocTopica("Torino");
        properties.setDataDocCronica(new Date());
        properties.setNumRepertorio("92");
        properties.setDocConAllegati(false);
        properties.setDocAutenticato(false);
        properties.setDocAutenticatoCopiaAutentica(false);
        properties.setDocAutenticatoFirmaAutenticata(false);

        // valore indicato in sede di analisi archivistica
        // recuperare tramite servizio query, entita "StatoDiEfficaciaDecodifica"
        // IdStatoDiEfficaciaType idStatoE = new IdStatoDiEfficaciaType();
        // idStatoE.setValue(2);

        String descrizioneStatoEfficacia = isAllegato ? "Non efficace di natura indeterminata" : "Perfetto ed efficace ma non firmato";
        IdStatoDiEfficaciaType idStatoE = queryForStatoEfficacia(descrizioneStatoEfficacia);
        if (idStatoE == null) {
            System.err.println("non trovato uno stato di efficacia con descrizione " + descrizioneStatoEfficacia);
            return null;
        }
        properties.setIdStatoDiEfficacia(idStatoE);

        // valore indicato in sede di analisi archivistica
        // recuperare tramite servizio query, entita "FormaDocumentariaDecodifica"
//        String descrizioneFormaDocumentaria = "";
//        IdFormaDocumentariaType idFormaDoc = queryForFormaDocumentaria(descrizioneFormaDocumentaria, CODICE_ENTE);
//        if (idFormaDoc == null) {
//            System.err.println("non trovata una forma documentaria con descrizione " + descrizioneFormaDocumentaria);
//            return null;
//        }
//        properties.setIdFormaDocumentaria(idFormaDoc);

        IdVitalRecordCodeType idVRC = null;
        try {
            // valore indicato in sede di analisi archivistica
            // recuperare tramite servizio managementService.getVitalRecordCode
            String vrcDescrizione = "medio";
            VitalRecordCodeType[] vrcArray = getServiziAcaris().getManagementServicePort().getVitalRecordCode(getRepositoryId());
            for (VitalRecordCodeType vrc : vrcArray) {
                if (vrcDescrizione.equalsIgnoreCase(vrc.getDescrizione())) {
                    idVRC = vrc.getIdVitalRecordCode();
                    break;
                }
            }
        } catch (Exception e) {
            System.err.println("errore nel recupero del vital record code tramite query!!!");
            return null;
        }

        properties.setIdVitalRecordCode(idVRC);

        // properties.setTipoDocFisico(EnumTipoDocumentoType.FIRMATO);
        properties.setTipoDocFisico(EnumTipoDocumentoType.SEMPLICE);
        // properties.setCodBarre("codiceBARRE");

        properties.setComposizione(EnumDocPrimarioType.DOCUMENTO_SINGOLO);
        properties.setMultiplo(false);
        properties.setRappresentazioneDigitale(true); // per doc elettronico
        return properties;
    }

    private ClassificazionePropertiesType creaClassificazionePropertiesType() {
        ClassificazionePropertiesType associativeObjectProperties = new ClassificazionePropertiesType();
        // associativeObjectProperties.setNumeroInput("1234124");
        // valore indicato in sede di analisi archivistica
        associativeObjectProperties.setCopiaCartacea(false);

        associativeObjectProperties.setCollocazioneCartacea("locazione polverosa");
        // valore indicato in sede di analisi archivistica
        associativeObjectProperties.setCartaceo(true);
        return associativeObjectProperties;
    }

    private DocumentoFisicoIRC[] creaDocumentoFisicoIRC() throws IOException {
        DocumentoFisicoIRC[] documenti = new DocumentoFisicoIRC[1];
        documenti[0] = new DocumentoFisicoIRC();
        DocumentoFisicoPropertiesType documentoFisicoProperty = new DocumentoFisicoPropertiesType();
        documentoFisicoProperty.setDescrizione("documento fisico");
        documentoFisicoProperty.setDataMemorizzazione(new Date());
        documenti[0].setPropertiesDocumentoFisico(documentoFisicoProperty);
        // creazione contenuto fisico e relativo stream dati
        documenti[0].setContenutiFisici(creaContenutoFisicoIRC());
        documenti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());
        return documenti;
    }

    private ContenutoFisicoIRC[] creaContenutoFisicoIRC() throws IOException {
        ContenutoFisicoIRC[] contenuti = new ContenutoFisicoIRC[1];
        contenuti[0] = new ContenutoFisicoIRC();
        AcarisContentStreamType contentStream = creaContentStream(FILE_FOLDER_PATH, "prova.pdf", "pdf", EnumMimeTypeType.APPLICATION_PDF);
        contenuti[0].setStream(contentStream);
        contenuti[0].setTipo(EnumStreamId.PRIMARY);
        // contenuti[0].setTipo(EnumStreamId.SIGNATURE);
        contenuti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());

        ContenutoFisicoPropertiesType contenutoFisicoPropertiesType = new ContenutoFisicoPropertiesType();
        // definire a true per sbustare il contenuto fisico
        contenutoFisicoPropertiesType.setSbustamento(false);
        contenuti[0].setPropertiesContenutoFisico(contenutoFisicoPropertiesType);
        return contenuti;
    }

    private AcarisContentStreamType creaContentStream(String filePath, final String fileName, final String estensioneFile, EnumMimeTypeType mimeType)
        throws IOException {

        AcarisContentStreamType contentStream = new AcarisContentStreamType();
        contentStream.setFilename(fileName);
        contentStream.setMimeType(mimeType);


        if (getServiziAcaris().isMtomEnabled()) {
//            final InputStream iS = new ByteArrayInputStream(stream);
//            final OutputStream oS = new ByteArrayOutputStream(stream.length);
//
//            javax.activation.DataSource a = new javax.activation.DataSource() {
//
//                public OutputStream getOutputStream() throws IOException {
//                    return oS;
//                }
//
//                public String getName() {
//                    return fileName;
//                }
//
//                public InputStream getInputStream() throws IOException {
//                    return iS;
//                }
//
//                public String getContentType() {
//                    return estensioneFile;
//                }
//            };

            File file = new File(filePath + fileName);
            javax.activation.DataSource a = new InputStreamDataSource(new FileInputStream(file), mimeType.value(), fileName);
            // valorizzare StreamMTOM se servizio invocato via WS SOAP
            contentStream.setStreamMTOM(new DataHandler(a));
        } else {
            // valorizzare Stream se servizio invocato via PAPD
            contentStream.setStream(getBytesFromFile(filePath + fileName));
        }

        return contentStream;
    }

    private final byte[] getBytesFromFile(String filePath) throws IOException {
        File file = new File(filePath);

        InputStream is = new FileInputStream(file);

        long length = file.length();

        if (length > Integer.MAX_VALUE) {
            System.out.println("File is too large");
        }

        byte[] bytes = new byte[(int) length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }

        if (offset < bytes.length) {
            System.out.println("File is too large" + file.getName());
        }

        is.close();
        return bytes;
    }

    private final it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] getDatiTestAzioniVerificaFirma() {

        it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] azioniVerificaFirma = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[7];
        for (int i = 0; i < 7; i++) {
            azioniVerificaFirma[i] = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction();
            azioniVerificaFirma[i].setAction(EnumStepErrorAction.INSERT);
            azioniVerificaFirma[i].setStep(i + 1);
        }

        return azioniVerificaFirma;
    }

    private ObjectIdType recuperaSoggettoActa(String codiceFiscaleMittenteEsterno) {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumRegistryObjectType.SOGGETTO_PROPERTIES_TYPE.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.ALL);

        QueryConditionType[] criteria = new QueryConditionType[1];
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("codiceFiscale");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(codiceFiscaleMittenteEsterno);
        criteria[0] = qct;

        ObjectIdType soggetto = null;

        try {
            PagingResponseType result = getServiziAcaris().getSubjectRegistryServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria,
                null, null, null);

            if (result != null && result.getObjectsLength() > 0) {
                soggetto = result.getObjects()[0].getObjectId();
            } else {
                System.err.println("codice fiscale " + codiceFiscaleMittenteEsterno + " non presente in anagrafica ACTA");
            }

        } catch (it.doqui.acta.acaris.subjectregistryservice.AcarisException acEx) {
            System.err.println("errore nel recupero soggetto in anagrafica");
            if (acEx.getMessage() != null && acEx.getFaultInfo() != null) {
                System.err.println("acEx.getMessage(): " + acEx.getMessage());
                System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
                EnumErrorCodeType errorCodeType = EnumErrorCodeType.fromValue(acEx.getFaultInfo().getErrorCode());
                System.err.println("acEx.getFaultInfo().getErrorCode():(da enum) " + errorCodeType.value());
                System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
                System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
                System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
                System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            } else {
                System.err.println(" fatal application exception ");
                System.err.println("ex.getMessage() " + acEx.getMessage());
            }
        } catch (Exception ex) {
            System.err.println("errore nel recupero soggetto in anagrafica");
            System.err.println("ex.getMessage() " + ex.getMessage());
        }

        return soggetto;
    }
    
    private String ricercaPerParolaChiave(String parolaChiave, EnumObjectType folderType) {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(folderType.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.NONE);

        QueryConditionType[] criteria = new QueryConditionType[1];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("paroleChiave");
        // ricerca della parola chiave ESATTA
        criteria[0].setOperator(EnumQueryOperator.EQUALS); 
        // ricerca della parola chiave CON WILDCARD * (fruitore deve specificare)
        // criteria[0].setOperator(EnumQueryOperator.LIKE);
        criteria[0].setValue(parolaChiave);

        Integer maxItems = new Integer(5);

        String objectIdAggregazione = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria, null,
                maxItems, null);

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                        && current.getValue().getContentLength() == 1) {
                        objectIdAggregazione = current.getValue().getContent(0);
                        System.out.println("Trovato " + folderType.name() + ", objectId " + objectIdAggregazione);
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            if (acEx.getMessage() != null && acEx.getFaultInfo() != null) {
                System.err.println("acEx.getMessage(): " + acEx.getMessage());
                System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
                System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
                System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
                System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
                System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            } else {
                System.err.println("fatal application exception");
                acEx.printStackTrace();
            }
        } catch (Exception ex) {
            System.err.println("ex.getMessage() " + ex.getMessage());
        }

        return objectIdAggregazione;
    }

    private IdStatoDiEfficaciaType queryForStatoEfficacia(String descrizioneStatoEfficacia) throws Exception {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject("StatoDiEfficaciaDecodifica");

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.LIST);

        List<QueryNameType> richieste = new ArrayList<QueryNameType>();
        QueryNameType richiesta = new QueryNameType();
        richiesta.setClassName(target.getObject());
        richiesta.setPropertyName("dbKey");
        richieste.add(richiesta);
        filter.setPropertyList(richieste.toArray(new QueryNameType[richieste.size()]));

        List<QueryConditionType> criteria = new ArrayList<QueryConditionType>();
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("descrizione");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descrizioneStatoEfficacia);
        criteria.add(qct);

        IdStatoDiEfficaciaType idStatoEfficacia = null;

        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter,
                criteria.toArray(new QueryConditionType[criteria.size()]), null, null, new Integer(0));

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("dbKey".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        idStatoEfficacia = new IdStatoDiEfficaciaType();
                        idStatoEfficacia.setValue(Long.parseLong(current.getValue().getContent(0)));
                        System.out.println("Trovato stato di efficacia " + descrizioneStatoEfficacia + ", value " + idStatoEfficacia.getValue());
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("errore nella ricerca dello stato di efficacia");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore nella ricerca dello stato di efficacia");
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }

        return idStatoEfficacia;
    }

    private IdFormaDocumentariaType queryForFormaDocumentaria(String descrizioneFormaDocumentaria, String descEnte) throws Exception {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject("FormaDocumentariaDecodifica");

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.LIST);

        List<QueryNameType> richieste = new ArrayList<QueryNameType>();
        QueryNameType richiesta = new QueryNameType();
        richiesta.setClassName(target.getObject());
        richiesta.setPropertyName("dbKey");
        richieste.add(richiesta);
        filter.setPropertyList(richieste.toArray(new QueryNameType[richieste.size()]));

        List<QueryConditionType> criteria = new ArrayList<QueryConditionType>();
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("descrizione");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descrizioneFormaDocumentaria);
        criteria.add(qct);
        qct = new QueryConditionType();
        qct.setPropertyName("descEnte");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(descrizioneFormaDocumentaria);
        criteria.add(qct);

        IdFormaDocumentariaType idFormaDocumentaria = null;

        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter,
                criteria.toArray(new QueryConditionType[criteria.size()]), null, null, new Integer(0));

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("dbKey".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        idFormaDocumentaria = new IdFormaDocumentariaType();
                        idFormaDocumentaria.setValue(Long.parseLong(current.getValue().getContent(0)));
                        System.out.println("Trovata forma documentaria " + descrizioneFormaDocumentaria + ", value " + idFormaDocumentaria.getValue());
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            System.err.println("errore nella ricerca della forma documentaria");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore nella ricerca della forma documentaria");
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }

        return idFormaDocumentaria;

    }
    
    public ObjectIdType queryFor(EnumObjectType targetType, long id) throws Exception{
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(targetType.value());
        
        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.NONE);
        
        QueryConditionType[] criteria = new QueryConditionType[1];
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("dbKey");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(String.valueOf(id));
        criteria[0] = qct;
        
        ObjectIdType objectId = null;
        
        try {
            PagingResponseType result = getServiziAcaris().getBackOfficeServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria, null,
                new Integer(5), null);
            
            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        objectId = new ObjectIdType();
                        objectId.setValue(current.getValue().getContent(0));
                        System.out.println("Trovato objectId per " + targetType.value());
                        break;
                    }
                }
            }
            
            if(objectId == null)
                System.err.println("nessun risultato per queryForAooStrutNodo su " + targetType.value());

        } catch (it.doqui.acta.acaris.backofficeservice.AcarisException acEx) {
            System.err.println("errore in recupero objectId per " + targetType.value());
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore in recupero objectId per " + targetType.value());
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }
        
        return objectId;
    }   
    
    public String queryForDescrizioneNodo(long idNodo) throws Exception{
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(EnumObjectType.NODO_PROPERTIES_TYPE.value());
        
        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.LIST);
        
        QueryNameType[] richieste = new QueryNameType[4];
        for(int i = 0; i < richieste.length; i++) {
            richieste[i] = new QueryNameType();
            richieste[i].setClassName(target.getObject());
        }
        
        richieste[2].setPropertyName("descNodo");
        filter.setPropertyList(richieste);
        
        QueryConditionType[] criteria = new QueryConditionType[1];
        QueryConditionType qct = new QueryConditionType();
        qct.setPropertyName("dbKey");
        qct.setOperator(EnumQueryOperator.EQUALS);
        qct.setValue(String.valueOf(idNodo));
        criteria[0] = qct;
        
        String descrizione = null;
        try {
            PagingResponseType result = getServiziAcaris().getBackOfficeServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria, null, new Integer(5), null);

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("descNodo".equals(current.getQueryName().getPropertyName()) && current.getValue() != null && current.getValue().getContentLength() == 1) {
                        descrizione = current.getValue().getContent(0);
                        break;
                    }
                }
            }
            
            if(descrizione == null)
                System.err.println("nessun risultato per queryForDescrizioneNodo");
            
        } catch (it.doqui.acta.acaris.backofficeservice.AcarisException acEx) {
            System.err.println("errore in recupero descrizione nodo");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            throw acEx;
        } catch (Exception ex) {
            System.err.println("errore in recupero descrizione nodo");
            System.err.println("ex.getMessage() " + ex.getMessage());
            throw ex;
        }
        
        return descrizione;
    }

    // utility
    private void stampa(ObjectResponseType[] recordset) {
        if (recordset == null) {
            System.out.println("ATTENZIONE: recordset null");
        } else {
            int max = recordset.length;
            for (int i = 0; i < max; i++) {
                System.out.println("--------------" + (i + 1) + "--------------");
                ObjectResponseType ort = null;
                if (recordset[i] != null) {
                    ort = recordset[i];
                    for (int j = 0; j < ort.getPropertiesLength(); j++) {
                        PropertyType pt = ort.getProperties(j);
                        System.out.println(pt.getQueryName().getClassName() + "." + pt.getQueryName().getPropertyName() + ": ");
                        for (int k = 0; k < pt.getValue().getContentLength(); k++) {
                            System.out.println("    " + pt.getValue().getContent(k));
                        }
                    }
                    System.out.println();
                }

            }
        }
    }

    private void stampa(IdentificatoreDocumento iDoc) {
        System.out.println("---------------------- IdentificatoreDocumento --------------------");
        String objectIdValue = iDoc.getObjectIdDocumento().getValue();
        System.out.println("objectId: " + objectIdValue);

        System.out.println("tipo documento: " + iDoc.getTipoDocumento().toString());
        System.out.println("data ultimo aggiornamento: " + iDoc.getDataUltimoAggiornamento().getValue());
    }

    private ObjectIdType getRepositoryId() {
        if (repositoryId == null) {
            repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
        }

        return repositoryId;
    }

    private PrincipalIdType getPrincipalId() {
        if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdStruttura(), getParametri().getIdNodo(), getParametri().getAppKey());
        }

        return principalId;
    }
    
    public ParametriAcaris getParametri() {
        return parametri;
    }

    public void setParametri(ParametriAcaris parametri) {
        this.parametri = parametri;
    }

    public ServiziAcaris getServiziAcaris() {
        return serviziAcaris;
    }

    public void setServiziAcaris(ServiziAcaris serviziAcaris) {
        this.serviziAcaris = serviziAcaris;
    }
    
    public static void main(String[] args) throws Exception {

        String server = "tst-applogic.reteunitaria.piemonte.it";
        int port = 80;
        String context = "/actasrv/";
        String repository = "";
        String cf = "";
        long idAoo = 0l;
        long idNodo = 0l;
        long idStruttura = 0l;
        String appKey = "";
        CreaRegistrazioneDaDocEsistenti testCreaReg = new CreaRegistrazioneDaDocEsistenti(server, context, port, repository, cf, idAoo, idNodo, idStruttura, appKey);
        
        System.out.println("\n ********************** test creaRegistrazione inizio");

        // objectId che identifica il folder in cui classificare,
        // cercato tramite query per paroleChiave
        String parolaChiave = "mtom_test";
        String objectIdVolume = testCreaReg.ricercaPerParolaChiave(parolaChiave, EnumObjectType.FASCICOLO_REALE_ANNUALE_PROPERTIES_TYPE);

        if (objectIdVolume == null) {
            System.err.println("nessun risultato per parola chiave " + parolaChiave);
            return;
        }

        ObjectIdType aggregazioneParent = new ObjectIdType();
        aggregazioneParent.setValue(objectIdVolume);

        ObjectIdType classificazionePrincipale;

        IdentificatoreDocumento result = testCreaReg.creaDocumentoElettronicoNonFirmato(aggregazioneParent, null);
        if (result != null) {
            classificazionePrincipale = result.getObjectIdClassificazione();
            System.out.println("creata classificazione con objectID " + result.getObjectIdClassificazione());
        } else {
            System.err.println("errore in classificazione documento principale");
            return;
        }

        for (int i = 0; i < N_CLASSIFICAZIONI_ALLEGATE; i++) {
            result = testCreaReg.creaDocumentoElettronicoNonFirmato(null, classificazionePrincipale);
            if (result != null)
                System.out.println("creata classificazione con objectID " + result.getObjectIdClassificazione());
            else {
                System.err.println("errore in allegato documento num " + i + 1);
                return;
            }
        }

        IdentificazioneRegistrazione resultProcollazione = testCreaReg.protocollazioneDocEsistenteInArrivo(classificazionePrincipale);
        
        if (resultProcollazione != null) {
            System.out.println("Registrazione creata");
            System.out.println("\tid " + resultProcollazione.getRegistrazioneId().getValue());
            System.out.println("\tnumero " + resultProcollazione.getNumero());
            System.out.println("\tdata " + resultProcollazione.getDataUltimoAggiornamento().getValue());
            
        }

    }
}
