package it.doqui.acta.actasrv.fruitori.esempi.smsService.creaSmistamento;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import javax.activation.DataHandler;

import it.doqui.acta.acaris.managementservice.AcarisException;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ClassificazionePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.ContenutoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoFisicoPropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.DocumentoSemplicePropertiesType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumDocPrimarioType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.EnumTipoDocumentoType;
import it.doqui.acta.actasrv.dto.acaris.type.archive.IdStatoDiEfficaciaType;
import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisContentStreamType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumMimeTypeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumStreamId;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdNodoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdSmistamentoType;
import it.doqui.acta.actasrv.dto.acaris.type.common.IdUtenteType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PrincipalIdType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryableObjectType;
import it.doqui.acta.actasrv.dto.acaris.type.document.ContenutoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoArchivisticoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.DocumentoFisicoIRC;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumStepErrorAction;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoDocumentoArchivistico;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumTipoOperazione;
import it.doqui.acta.actasrv.dto.acaris.type.document.IdentificatoreDocumento;
import it.doqui.acta.actasrv.dto.acaris.type.management.VitalRecordCodeType;
import it.doqui.acta.actasrv.dto.acaris.type.sms.DestinatarioType;
import it.doqui.acta.actasrv.dto.acaris.type.sms.IdTipoSmistamentoType;
import it.doqui.acta.actasrv.dto.acaris.type.sms.InfoCreazioneType;
import it.doqui.acta.actasrv.dto.acaris.type.sms.MittenteType;
import it.doqui.acta.actasrv.dto.acaris.type.sms.OggettoSmistamentoType;
import it.doqui.acta.actasrv.fruitori.ConfigurazioneFruitore;
import it.doqui.acta.actasrv.fruitori.ParametriAcaris;
import it.doqui.acta.actasrv.fruitori.esempi.utility.ServiziAcaris;

public class CreaDocumentoESmista {

    private static final String PART228_SERVER = "tst-applogic.reteunitaria.piemonte.it";
    private static final String PART228_CONTEXT = "actasrv";
    private static final int PART228_PORT = 80;
            
    // utilizzare la configurazione trasmessa via mail sviluppo integrazione 
    private static final String COD_FISCALE = "";
    private static final long ID_AOO = 0L;
    private static final long ID_NODO = 0L;
    private static final long ID_STRUTTURA = 0L;
    private static final String APP_KEY = "";
    private static final String CODICE_ENTE = "RP201209";
    private static final String DESCRIZIONE_ENTE = "Regione Piemonte - Agg. 09/2012";
    private static final String REPOSITORY_NAME = CODICE_ENTE + " " + DESCRIZIONE_ENTE;
    
    private final static boolean MTOM_ENABLED = true; // se si effettua invocazione via WS
    // false; //se si effettua invocazione via PAPD
    
    private ConfigurazioneFruitore configurazione = null;
    
    private ParametriAcaris parametri;
    private ServiziAcaris serviziAcaris;
    
    // NUMERO DI CLASSIFICAZIONI DA CREARE E SMISTARE ALLO STESSO TEMPO
    private static final int N_CLASSIFICAZIONI = 1;

    private final long idUtente = 17;

    // id nodo a cui smistare
    // private final long idNodoDestinazione = idNodo;
    private final long idNodoDestinazione = 2323; // nodo A140-R

    // repositoryId ottenuto dall'invocazione del getRepositories
    private ObjectIdType repositoryId;
    // principalId ottenuto tramite invocazione del servizio getPrincipalExt
    private PrincipalIdType principalId;

    private static final BigDecimal TIPO_SMISTAMENTO_COMPETENZA = new BigDecimal(1);
    private static final BigDecimal TIPO_SMISTAMENTO_CONOSCENZA = new BigDecimal(2);
    private static final String FILE_FOLDER_PATH = "files" + File.separatorChar;

    public CreaDocumentoESmista() {
        this.configurazione = new ConfigurazioneFruitore(PART228_SERVER, PART228_CONTEXT, PART228_PORT, REPOSITORY_NAME, COD_FISCALE, ID_AOO, ID_NODO, ID_STRUTTURA,
            APP_KEY, MTOM_ENABLED);
        parametri = this.configurazione.getParametri();
        serviziAcaris = this.configurazione.getServiziAcaris();
    }

    public final IdSmistamentoType creaSmistamentoDaClassificazione(ObjectIdType[] classificazioni, long idTipoSmist) {

        MittenteType mittente = new MittenteType();
        InfoCreazioneType infoCreazione = new InfoCreazioneType();
        IdUtenteType idUtenteType = new IdUtenteType();
        idUtenteType.setValue(idUtente);
        mittente.setUtente(idUtenteType);

        DestinatarioType[] destinatari = new DestinatarioType[1];
        IdNodoType idNodoType = new IdNodoType();
        idNodoType.setValue(idNodoDestinazione);
        DestinatarioType dest = new DestinatarioType();
        dest.setNodoOrganizzativo(idNodoType);
        destinatari[0] = dest;

        ArrayList<OggettoSmistamentoType> oggettiSmistati = new ArrayList<OggettoSmistamentoType>();
        for (ObjectIdType classificazione : classificazioni) {
            OggettoSmistamentoType ogg = new OggettoSmistamentoType();
            ogg.setClassificazione(classificazione);
            oggettiSmistati.add(ogg);
        }

        IdTipoSmistamentoType idTipoSms = new IdTipoSmistamentoType();
        idTipoSms.setValue(idTipoSmist);
        infoCreazione.setTipoSmistamento(idTipoSms);

        IdSmistamentoType result = null;
        try {
            result = getServiziAcaris().getSmsServicePort().creaSmistamento(getRepositoryId(), getPrincipalId(), mittente, destinatari,
                oggettiSmistati.toArray(new OggettoSmistamentoType[oggettiSmistati.size()]), infoCreazione);
        } catch (it.doqui.acta.acaris.smsservice.AcarisException acEx) {
            if (acEx.getMessage() != null && acEx.getFaultInfo() != null) {
                System.out.println("acEx.getMessage(): " + acEx.getMessage());
                System.out.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
                System.out.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
                System.out.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
                System.out.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
                System.out.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            } else {
                System.out.println(" fatal application exception ");
            }
        } catch (Exception ex) {
            System.out.println("ex.getMessage() " + ex.getMessage());
        }

        return result;
    }

    public IdentificatoreDocumento creaDocumentoElettronicoNonFirmato(ObjectIdType parentFolder) {

        IdentificatoreDocumento documentId = null;

        DocumentoArchivisticoIRC datiCreazione = new DocumentoArchivisticoIRC();
        datiCreazione.setParentFolderId(parentFolder);
        datiCreazione.setTipoDocumento(EnumTipoDocumentoArchivistico.DOCUMENTO_SEMPLICE);
        datiCreazione.setPropertiesClassificazione(creaClassificazionePropertiesType());

        try {
            datiCreazione.setPropertiesDocumento(creaDocumentoSemplicePropertiesType());
            datiCreazione.setDocumentiFisici(creaDocumentoFisicoIRC());

            documentId = getServiziAcaris().getDocumentServicePort().creaDocumento(getRepositoryId(), getPrincipalId(), EnumTipoOperazione.ELETTRONICO,
                datiCreazione);
        } catch (it.doqui.acta.acaris.documentservice.AcarisException acEx) {
            System.err.println("errore in classificazione documento");
            System.err.println("acEx.getMessage(): " + acEx.getMessage());
            System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
            System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
            System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
            System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
            System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
        } catch (IOException e) {
            System.err.println("errore nella creazione del contenuto fisico");
            e.printStackTrace();
        } catch (Exception ex) {
            System.err.println("errore in classificazione documento");
            ex.printStackTrace();
        }

        if (documentId != null) {
            System.out.println("Classificazione creata con successo");
            stampa(documentId);
        }

        return documentId;
    }

    private DocumentoSemplicePropertiesType creaDocumentoSemplicePropertiesType() throws AcarisException {
        DocumentoSemplicePropertiesType properties = new DocumentoSemplicePropertiesType();

        properties.setRegistrato(false);
        properties.setDefinitivo(true);
        properties.setModificabile(false);

        properties.setOrigineInterna(true);
        properties.setAnalogico(false);
        properties.setDaConservare(false);
        properties.setProntoPerConservazione(false);
// SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
// properties.setDaConservareDopoIl(formatDate.parse("06/10/2010"));
// properties.setDaConservarePrimaDel(formatDate.parse("06/10/2010"));
        properties.setDaConservarePrimaDel(null);
        properties.setDatiPersonali(true);
        properties.setDatiRiservati(false);
        properties.setDatiSensibili(false);
        properties.setParoleChiave("test-creaDocumento-acaristeam");
        String[] autore = { "pippo|PPPPPP80A01L219I", "topolino|TPLMCK17A01L219B" };
        properties.setAutoreGiuridico(autore);
        properties.setAutoreFisico(autore);
        properties.setScrittore(autore);
        properties.setOriginatore(autore);
        properties.setDestinatarioGiuridico(autore);
        properties.setDestinatarioFisico(autore);
        properties.setOggetto("test crea documento - esempio");
        // properties.setOggetto(null);
        properties.setDataDocTopica("Torino");
        properties.setDataDocCronica(new Date());
        properties.setNumRepertorio("92");
        properties.setDocConAllegati(false);
        properties.setDocAutenticato(false);
        properties.setDocAutenticatoCopiaAutentica(false);
        properties.setDocAutenticatoFirmaAutenticata(false);

        // valore indicato in sede di analisi archivistica
        // recuperare tramite servizio query, entita "StatoDiEfficaciaDecodifica"
        IdStatoDiEfficaciaType idStatoE = new IdStatoDiEfficaciaType();
        idStatoE.setValue(2);
        properties.setIdStatoDiEfficacia(idStatoE);

        // valore indicato in sede di analisi archivistica
        // recuperare tramite servizio query, entita "FormaDocumentariaDecodifica"
//        String descrizioneFormaDocumentaria = "";
//        IdFormaDocumentariaType idFormaDoc = queryForFormaDocumentaria(descrizioneFormaDocumentaria, CODICE_ENTE);
//        if (idFormaDoc == null) {
//            System.err.println("non trovata una forma documentaria con descrizione " + descrizioneFormaDocumentaria);
//            return null;
//        }
//        properties.setIdFormaDocumentaria(idFormaDoc);

        // valore indicato in sede di analisi archivistica
        // recuperare tramite servizio managementService.getVitalRecordCode
        String vrcDescrizione = "medio";
        VitalRecordCodeType[] vrcArray = getServiziAcaris().getManagementServicePort().getVitalRecordCode(getRepositoryId());
        for (VitalRecordCodeType vrc : vrcArray) {
            if (vrcDescrizione.equalsIgnoreCase(vrc.getDescrizione())) {
                properties.setIdVitalRecordCode(vrc.getIdVitalRecordCode());
                break;
            }
        }

        // properties.setTipoDocFisico(EnumTipoDocumentoType.FIRMATO);
        properties.setTipoDocFisico(EnumTipoDocumentoType.SEMPLICE);
        // properties.setCodBarre("codiceBARRE");

        properties.setComposizione(EnumDocPrimarioType.DOCUMENTO_SINGOLO);
        properties.setMultiplo(false);
        properties.setRappresentazioneDigitale(true); // per doc elettronico
        return properties;
    }

    private ClassificazionePropertiesType creaClassificazionePropertiesType() {
        ClassificazionePropertiesType associativeObjectProperties = new ClassificazionePropertiesType();
        // associativeObjectProperties.setNumeroInput("1234124");
        // valore indicato in sede di analisi archivistica
        associativeObjectProperties.setCopiaCartacea(false);

        associativeObjectProperties.setCollocazioneCartacea("locazione polverosa");
        // valore indicato in sede di analisi archivistica
        associativeObjectProperties.setCartaceo(true);
        return associativeObjectProperties;
    }

    private DocumentoFisicoIRC[] creaDocumentoFisicoIRC() throws IOException {
        DocumentoFisicoIRC[] documenti = new DocumentoFisicoIRC[1];
        documenti[0] = new DocumentoFisicoIRC();
        DocumentoFisicoPropertiesType documentoFisicoProperty = new DocumentoFisicoPropertiesType();
        documentoFisicoProperty.setDescrizione("documento fisico");
        documentoFisicoProperty.setDataMemorizzazione(new Date());
        documenti[0].setPropertiesDocumentoFisico(documentoFisicoProperty);
        // creazione contenuto fisico e relativo stream dati
        documenti[0].setContenutiFisici(creaContenutoFisicoIRC());
        documenti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());
        return documenti;
    }

    private ContenutoFisicoIRC[] creaContenutoFisicoIRC() throws IOException {
        ContenutoFisicoIRC[] contenuti = new ContenutoFisicoIRC[1];
        contenuti[0] = new ContenutoFisicoIRC();
        AcarisContentStreamType contentStream = creaContentStream(FILE_FOLDER_PATH, "prova.pdf", "pdf", EnumMimeTypeType.APPLICATION_PDF);
        contenuti[0].setStream(contentStream);
        contenuti[0].setTipo(EnumStreamId.PRIMARY);
        // contenuti[0].setTipo(EnumStreamId.SIGNATURE);
        contenuti[0].setAzioniVerificaFirma(getDatiTestAzioniVerificaFirma());

        ContenutoFisicoPropertiesType contenutoFisicoPropertiesType = new ContenutoFisicoPropertiesType();
        // definire a true per sbustare il contenuto fisico
        contenutoFisicoPropertiesType.setSbustamento(false);
        contenuti[0].setPropertiesContenutoFisico(contenutoFisicoPropertiesType);
        return contenuti;
    }

    private AcarisContentStreamType creaContentStream(String filePath, final String fileName, final String estensioneFile, EnumMimeTypeType mimeType)
        throws IOException {

        AcarisContentStreamType contentStream = new AcarisContentStreamType();
        contentStream.setFilename(fileName);
        contentStream.setMimeType(mimeType);

        byte[] stream = getBytesFromFile(filePath + fileName);

        if (getServiziAcaris().isMtomEnabled()) {
            final InputStream iS = new ByteArrayInputStream(stream);
            final OutputStream oS = new ByteArrayOutputStream(stream.length);

            javax.activation.DataSource a = new javax.activation.DataSource() {

                public OutputStream getOutputStream() throws IOException {
                    return oS;
                }

                public String getName() {
                    return fileName;
                }

                public InputStream getInputStream() throws IOException {
                    return iS;
                }

                public String getContentType() {
                    return estensioneFile;
                }
            };

            // valorizzare StreamMTOM se servizio invocato via WS SOAP
            contentStream.setStreamMTOM(new DataHandler(a));
        } else {
            // valorizzare Stream se servizio invocato via PAPD
            contentStream.setStream(stream);
        }

        return contentStream;
    }

    private final byte[] getBytesFromFile(String filePath) throws IOException {
        File file = new File(filePath);

        InputStream is = new FileInputStream(file);

        long length = file.length();

        if (length > Integer.MAX_VALUE) {
            System.out.println("File is too large");
        }

        byte[] bytes = new byte[(int) length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }

        if (offset < bytes.length) {
            System.out.println("File is too large" + file.getName());
        }

        is.close();
        return bytes;
    }

    private final it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] getDatiTestAzioniVerificaFirma() {

        it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] azioniVerificaFirma = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[7];
        for (int i = 0; i < 7; i++) {
            azioniVerificaFirma[i] = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction();
            azioniVerificaFirma[i].setAction(EnumStepErrorAction.INSERT);
            azioniVerificaFirma[i].setStep(i + 1);
        }

        return azioniVerificaFirma;
    }

    private final String ricercaPerParolaChiave(String parolaChiave, EnumObjectType folderType) {
        QueryableObjectType target = new QueryableObjectType();
        target.setObject(folderType.value());

        PropertyFilterType filter = new PropertyFilterType();
        filter.setFilterType(EnumPropertyFilter.NONE);

        QueryConditionType[] criteria = new QueryConditionType[1];
        criteria[0] = new QueryConditionType();
        criteria[0].setPropertyName("paroleChiave");
        criteria[0].setOperator(EnumQueryOperator.EQUALS); //ricerca della parola chiave ESATTA
//      criteria[0].setOperator(EnumQueryOperator.LIKE); //ricerca della parola chiave CON WILDCARD * (fruitore deve specificare)
        criteria[0].setValue(parolaChiave);

        Integer maxItems = new Integer(5);

        String objectIdVolume = null;
        try {
            PagingResponseType result = getServiziAcaris().getObjectServicePort().query(getRepositoryId(), getPrincipalId(), target, filter, criteria, null,
                maxItems, null);

            if (result != null && result.getObjectsLength() == 1 && result.getObjects(0) != null && result.getObjects(0).getPropertiesLength() > 0) {
                for (PropertyType current : result.getObjects(0).getProperties()) {
                    if ("objectId".equals(current.getQueryName().getPropertyName()) && current.getValue() != null
                        && current.getValue().getContentLength() == 1) {
                        objectIdVolume = current.getValue().getContent(0);
                        System.out.println("Trovato " + folderType.name() + ", objectId " + objectIdVolume);
                        break;
                    }
                }
            }

        } catch (it.doqui.acta.acaris.objectservice.AcarisException acEx) {
            if (acEx.getMessage() != null && acEx.getFaultInfo() != null) {
                System.err.println("acEx.getMessage(): " + acEx.getMessage());
                System.err.println("acEx.getFaultInfo().getErrorCode(): " + acEx.getFaultInfo().getErrorCode());
                System.err.println("acEx.getFaultInfo().getPropertyName(): " + acEx.getFaultInfo().getPropertyName());
                System.err.println("acEx.getFaultInfo().getObjectId(): " + acEx.getFaultInfo().getObjectId());
                System.err.println("acEx.getFaultInfo().getExceptionType(): " + acEx.getFaultInfo().getExceptionType());
                System.err.println("acEx.getFaultInfo().getClassName(): " + acEx.getFaultInfo().getClassName());
            } else {
                System.err.println("fatal application exception");
                acEx.printStackTrace();
            }
        } catch (Exception ex) {
            System.err.println("ex.getMessage() " + ex.getMessage());
        }

        return objectIdVolume;
    }

    // utility
    private void stampa(ObjectResponseType[] recordset) {
        if (recordset == null) {
            System.out.println("ATTENZIONE: recordset null");
        } else {
            int max = recordset.length;
            for (int i = 0; i < max; i++) {
                System.out.println("--------------" + (i + 1) + "--------------");
                ObjectResponseType ort = null;
                if (recordset[i] != null) {
                    ort = recordset[i];
                    for (int j = 0; j < ort.getPropertiesLength(); j++) {
                        PropertyType pt = ort.getProperties(j);
                        System.out.println(pt.getQueryName().getClassName() + "." + pt.getQueryName().getPropertyName() + ": ");
                        for (int k = 0; k < pt.getValue().getContentLength(); k++) {
                            System.out.println("    " + pt.getValue().getContent(k));
                        }
                    }
                    System.out.println();
                }

            }
        }
    }

    private void stampa(IdentificatoreDocumento iDoc) {
        System.out.println("---------------------- IdentificazioneDocumento --------------------");
        String objectIdValue = iDoc.getObjectIdDocumento().getValue();
        System.out.println("objectId: " + objectIdValue);

        System.out.println("tipo documento: " + iDoc.getTipoDocumento().toString());
        System.out.println("data ultimo aggiornamento: " + iDoc.getDataUltimoAggiornamento().getValue());
    }

    private ObjectIdType getRepositoryId() {
        if (repositoryId == null) {
            repositoryId = getServiziAcaris().getRepositoryId(getParametri().getRepositoryName());
        }

        return repositoryId;
    }

    private PrincipalIdType getPrincipalId() {
        if (principalId == null) {
            principalId = getServiziAcaris().getPrincipalExt(getRepositoryId(), getParametri().getCodiceFiscale(), getParametri().getIdAoo(),
                getParametri().getIdAoo(), getParametri().getIdNodo(), getParametri().getAppKey());
        }

        return principalId;
    }
    
    private ServiziAcaris getServiziAcaris() {
        return this.serviziAcaris;
    }
    
    private ParametriAcaris getParametri() {
        return this.parametri;
    }

    public static void main(String[] args) {

        CreaDocumentoESmista testCD = new CreaDocumentoESmista();
        System.out.println("\n ********************** test creaDocumento inizio");

        // objectId che identifica il folder in cui classificare,
        // cercato tramite query per paroleChiave
        String parolaChiave = "acaris-smista-classificazione-0308";
        String objectIdVolume = testCD.ricercaPerParolaChiave(parolaChiave, EnumObjectType.FASCICOLO_REALE_ANNUALE_PROPERTIES_TYPE);

        if (objectIdVolume == null) {
            System.err.println("nessun risultato per parola chiave " + parolaChiave);
            return;
        }

        ObjectIdType aggregazioneParent = new ObjectIdType();
        aggregazioneParent.setValue(objectIdVolume);
        ObjectIdType[] classificazioniDaSmistare = new ObjectIdType[N_CLASSIFICAZIONI];

        for (int i = 0; i < N_CLASSIFICAZIONI; i++) {
            IdentificatoreDocumento result = testCD.creaDocumentoElettronicoNonFirmato(aggregazioneParent);
            if (result != null)
                classificazioniDaSmistare[i] = result.getObjectIdClassificazione();
            else {
                System.out.println("errore in classificazione documento num " + i + 1);
                return;
            }
        }

        IdSmistamentoType result = testCD.creaSmistamentoDaClassificazione(classificazioniDaSmistare, TIPO_SMISTAMENTO_COMPETENZA.longValue());

        if (result != null)
            System.out.println("Smistamento creato, id " + result.getValue());

    }
}
