/**
 * TestUtils.java
 * 
 * AVVERTENZA 
 * Questaq classe contiene una serie di metodi di utilit� per facilitare le prime 
 * fasi di sviluppo dell'integrazione con ACTA tramite esposizione ACARIS: 
 * ogni verticale pu� decidere di gestire come meglio crede il recupero delle 
 * informazioni che seguono
 */

package it.doqui.acta.actasrv.fruitori.esempi.utility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;

import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisContentStreamType;
import it.doqui.acta.actasrv.dto.acaris.type.common.AcarisFaultType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumMimeTypeType;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumPropertyFilter;
import it.doqui.acta.actasrv.dto.acaris.type.common.EnumQueryOperator;
import it.doqui.acta.actasrv.dto.acaris.type.common.ObjectResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PagingResponseType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyFilterType;
import it.doqui.acta.actasrv.dto.acaris.type.common.PropertyType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryConditionType;
import it.doqui.acta.actasrv.dto.acaris.type.common.QueryNameType;
import it.doqui.acta.actasrv.dto.acaris.type.document.EnumStepErrorAction;

public final class TestUtils {
    
    private TestUtils() {}

    public static AcarisContentStreamType creaContentStream(String filePath, final String fileName, final String estensioneFile, EnumMimeTypeType mimeType,
        boolean isWS) throws IOException {

        AcarisContentStreamType contentStream = new AcarisContentStreamType();
        contentStream.setFilename(fileName);
        contentStream.setMimeType(mimeType);

        byte[] stream = getBytesFromFile(filePath + fileName);

        if (isWS) {
            final InputStream iS = new ByteArrayInputStream(stream);
            final OutputStream oS = new ByteArrayOutputStream(stream.length);

            javax.activation.DataSource a = new javax.activation.DataSource() {

                public OutputStream getOutputStream() throws IOException {
                    return oS;
                }

                public String getName() {
                    return fileName;
                }

                public InputStream getInputStream() throws IOException {
                    return iS;
                }

                public String getContentType() {
                    return estensioneFile;
                }
            };

            // valorizzare StreamMTOM se servizio invocato via WS SOAP
            contentStream.setStreamMTOM(new DataHandler(a));
        } else {
            // valorizzare Stream se servizio invocato via PAPD
            contentStream.setStream(stream);
        }

        return contentStream;
    }

    public static byte[] getBytesFromFile(String filePath) throws IOException {
        File file = new File(filePath);

        InputStream is = new FileInputStream(file);

        long length = file.length();

        if (length > Integer.MAX_VALUE) {
            System.err.println("File is too large");
        }

        byte[] bytes = new byte[(int) length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }

        if (offset < bytes.length) {
            System.err.println("File is too large" + file.getName());
        }

        is.close();
        return bytes;
    }

    public static it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] getDatiTestAzioniVerificaFirma() {

        it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[] azioniVerificaFirma = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction[7];
        for (int i = 0; i < 7; i++) {
            azioniVerificaFirma[i] = new it.doqui.acta.actasrv.dto.acaris.type.document.StepErrorAction();
            azioniVerificaFirma[i].setAction(EnumStepErrorAction.INSERT);
            azioniVerificaFirma[i].setStep(i + 1);
        }

        return azioniVerificaFirma;
    }

    /**********************************************************************************************************
     * visualizzazione risultati
     *********************************************************************************************************/

    public static void stampa(PagingResponseType pagingResponseType) {
        if (pagingResponseType == null) {
            System.out.println("ATTENZIONE: recordset null");
        } else {
            int max = pagingResponseType.getObjectsLength();
            for (int i = 0; i < max; i++) {
                System.out.println("--------------" + (i + 1) + "--------------");
                ObjectResponseType ort = pagingResponseType.getObjects(i);
                for (int j = 0; j < ort.getPropertiesLength(); j++) {
                    PropertyType pt = ort.getProperties(j);
                    System.out.println(pt.getQueryName().getClassName() + "." + pt.getQueryName().getPropertyName() + ": ");
                    for (int k = 0; k < pt.getValue().getContentLength(); k++) {
                        System.out.println("    " + pt.getValue().getContent(k));
                    }
                }
                System.out.println();
            }
        }
    }

    /**********************************************************************************************************
     * utilities
     *********************************************************************************************************/
    public static PropertyFilterType getPropertyFilterNone() {
        return getPropertyFilter(EnumPropertyFilter.NONE, null, null, null);
    }

    public static PropertyFilterType getPropertyFilterAll() {
        return getPropertyFilter(EnumPropertyFilter.ALL, null, null, null);
    }

    public static PropertyFilterType getPropertyFilterList(String[] className, String[] propertyName, PropertyFilterType prevFilter) {
        return getPropertyFilter(EnumPropertyFilter.LIST, className, propertyName, prevFilter);
    }

    private static PropertyFilterType getPropertyFilter(EnumPropertyFilter type, String[] className, String[] propertyName, PropertyFilterType prevFilter) {
        PropertyFilterType filter = null;
        if (type != null) {
            if (type.value().equals(EnumPropertyFilter.LIST.value())) {
                filter = (prevFilter != null) ? prevFilter : new PropertyFilterType();
                filter.setFilterType(type);
                List<QueryNameType> properties = new ArrayList<QueryNameType>();
                QueryNameType property = null;
                if (className.length == propertyName.length) {
                    if (prevFilter != null && prevFilter.getFilterType().value().equals(EnumPropertyFilter.LIST.value())
                        && prevFilter.getPropertyListLength() > 0) {
                        for (int j = 0; j < prevFilter.getPropertyListLength(); j++) {
                            properties.add(prevFilter.getPropertyList(j));
                        }
                    }
                    for (int i = 0; i < propertyName.length; i++) {
                        property = new QueryNameType();
                        property.setClassName(className[i]);
                        property.setPropertyName(propertyName[i]);
                        properties.add(property);
                    }
                    filter.setPropertyList(properties.toArray(new QueryNameType[0]));
                } else
                    return null;

            } else {
                filter = new PropertyFilterType();
                filter.setFilterType(type);
            }
        }
        return filter;
    }

    public static QueryConditionType[] getCriteria(EnumQueryOperator[] operator, String[] propertyName, String[] value) {
        QueryConditionType[] criteria = null;
        if ((operator != null && operator.length > 0) && (propertyName != null && propertyName.length > 0) && (value != null && value.length > 0)
            && (operator.length == propertyName.length && operator.length == value.length)) {
            List<QueryConditionType> criteri = new ArrayList<QueryConditionType>();
            QueryConditionType criterio = null;
            for (int i = 0; i < propertyName.length; i++) {
                criterio = new QueryConditionType();
                criterio.setOperator(operator[i]);
                criterio.setPropertyName(propertyName[i]);
                criterio.setValue(value[i]);
                criteri.add(criterio);
            }
            criteria = criteri.toArray(new QueryConditionType[0]);
        }
        return criteria;
    }
    
    public static void printAcarisException(String metodo, String errorMessage, AcarisFaultType faultInfo) {
        System.err.print(metodo + ": acEx.getMessage(): " + errorMessage);
        System.err.print("\n\tacEx.getFaultInfo().getErrorCode(): " + faultInfo.getErrorCode());
        System.err.print("\n\tacEx.getFaultInfo().getPropertyName(): " + faultInfo.getPropertyName());
        System.err.print("\n\tacEx.getFaultInfo().getObjectId(): " + faultInfo.getObjectId());
        System.err.print("\n\tacEx.getFaultInfo().getExceptionType(): " + faultInfo.getExceptionType());
        System.err.println("\n\tacEx.getFaultInfo().getClassName(): " + faultInfo.getClassName());
    }
}
